/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EODocument;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication.EOObjectDisplay;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOXMLUnarchiver;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.eogeneration._EOKeyPathUtility;
import com.webobjects.eointerface.EODisplayGroup;
import com.webobjects.eointerface.EOMasterDetailAssociation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSUndoManager;
import com.webobjects.foundation._NSUtilities;

public abstract class EOEditingController
extends EODocumentController {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOEditingController");
    private EOMasterDetailAssociation _masterDetailAssociation = null;
    private String _relationshipPath = null;
    private NSArray _mandatoryRelationshipPaths = null;
    private String _derivedEntityName = null;
    private int _canSelectWithEntityName = 0;
    private int _canInsertWithEntityName = 0;
    private int _canOpenGlobalIDsWithEntityName = 0;
    private int _canOpenWithEntityName = 0;
    private int _canSelectByInsertingWithEntityName = 0;
    private int _relationshipPathRepresentsToOneRelationship = 0;
    private int _relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject = 0;
    private int _canOpenWithRelationshipPath = 0;

    public EOEditingController() {
    }

    public EOEditingController(EOXMLUnarchiver unarchiver) {
        super(unarchiver);
        this.setRelationshipPath(unarchiver.decodeStringForKey("path"));
        this.setMandatoryRelationshipPaths(unarchiver.decodeArrayForKey("mandatoryRelationshipPaths"));
    }

    public NSMutableDictionary _xmlParameters() {
        NSMutableDictionary parameters = super._xmlParameters();
        if (this._relationshipPath != null && this._relationshipPath.length() > 0) {
            parameters.setObjectForKey((Object)this._relationshipPath, (Object)"path");
            parameters.removeObjectForKey((Object)"entity");
        }
        if (this._mandatoryRelationshipPaths != null && this._mandatoryRelationshipPaths.count() > 0) {
            parameters.setObjectForKey((Object)this._mandatoryRelationshipPaths, (Object)"mandatoryRelationshipPaths");
        }
        return parameters;
    }

    public void dispose() {
        super.dispose();
        if (this._masterDetailAssociation != null) {
            this._masterDetailAssociation.dispose();
            this._masterDetailAssociation = null;
        }
    }

    protected boolean disposeIfTransient() {
        EOMasterDetailAssociation association = this._masterDetailAssociation;
        this._masterDetailAssociation = null;
        if (!super.disposeIfTransient()) {
            this._masterDetailAssociation = association;
            return false;
        }
        return true;
    }

    protected void connectionWasEstablished() {
        EOMasterDetailAssociation association = this.masterDetailAssociation();
        if (association != null) {
            association.establishConnection();
        }
        this._derivedEntityName = null;
        this._canOpenWithRelationshipPath = 0;
        this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject = 0;
        this._relationshipPathRepresentsToOneRelationship = 0;
        this._canSelectByInsertingWithEntityName = 0;
        this._canOpenWithEntityName = 0;
        this._canOpenGlobalIDsWithEntityName = 0;
        this._canInsertWithEntityName = 0;
        this._canSelectWithEntityName = 0;
        super.connectionWasEstablished();
    }

    protected void connectionWasBroken() {
        if (this._masterDetailAssociation != null) {
            this._masterDetailAssociation.breakConnection();
        }
        super.connectionWasBroken();
    }

    public boolean fetchesOnConnect() {
        return this.relationshipPath() != null ? false : super.fetchesOnConnect();
    }

    public void setRelationshipPath(String string) {
        if (this._hasEverBeenConnected()) {
            this._raiseBecauseOfIllegalPropertyChange("relationshipPath", null, false);
        }
        this._relationshipPath = string;
        this._canOpenWithRelationshipPath = 0;
        this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject = 0;
        this._relationshipPathRepresentsToOneRelationship = 0;
        this.resetActions();
    }

    public String relationshipPath() {
        return this._relationshipPath;
    }

    public void setMandatoryRelationshipPaths(NSArray relationshipPaths) {
        this._mandatoryRelationshipPaths = relationshipPaths;
        this._canOpenWithRelationshipPath = 0;
        this.resetActions();
    }

    protected NSArray mandatoryRelationshipPaths() {
        if (this._mandatoryRelationshipPaths == null) {
            NSArray keys;
            EOClassDescription classDescription;
            String entityName;
            NSMutableArray mandatoryRelationshipPaths = new NSMutableArray();
            if (this.relationshipPath() != null && (entityName = this.entityName()) != null && (classDescription = EOClassDescription.classDescriptionForEntityName((String)entityName)) != null && (keys = classDescription.toOneRelationshipKeys()) != null) {
                int count = keys.count();
                for (int i = 0; i < count; ++i) {
                    String key = (String)keys.objectAtIndex(i);
                    EOClassDescription destinationClassDescription = classDescription.classDescriptionForDestinationKey(key);
                    if (destinationClassDescription == null) continue;
                    String destinationEntityName = destinationClassDescription.entityName();
                    if (!EOControllerFactory.sharedControllerFactory()._isMainEntity(destinationEntityName)) continue;
                    mandatoryRelationshipPaths.addObject((Object)key);
                }
            }
            this.setMandatoryRelationshipPaths((NSArray)mandatoryRelationshipPaths);
        }
        return this._mandatoryRelationshipPaths;
    }

    protected boolean _canSelectWithEntityName() {
        if (this._canSelectWithEntityName == 0) {
            this._canSelectWithEntityName = EOControllerFactory.sharedControllerFactory().canSelectWithEntityName(this.entityName()) ? 1 : 2;
        }
        return this._canSelectWithEntityName == 1;
    }

    protected boolean _canInsertWithEntityName() {
        if (this._canInsertWithEntityName == 0) {
            this._canInsertWithEntityName = EOControllerFactory.sharedControllerFactory().canInsertWithEntityName(this.entityName()) ? 1 : 2;
        }
        return this._canInsertWithEntityName == 1;
    }

    protected boolean _canOpenGlobalIDsWithEntityName() {
        if (this._canOpenGlobalIDsWithEntityName == 0) {
            this._canOpenGlobalIDsWithEntityName = EOControllerFactory.sharedControllerFactory().canOpenGlobalIDsWithEntityName(this.entityName()) ? 1 : 2;
        }
        return this._canOpenGlobalIDsWithEntityName == 1;
    }

    protected boolean _canOpenWithEntityName() {
        if (this._canOpenWithEntityName == 0) {
            this._canOpenWithEntityName = EOControllerFactory.sharedControllerFactory().canOpenWithEntityName(this.entityName()) ? 1 : 2;
        }
        return this._canOpenWithEntityName == 1;
    }

    protected boolean _canSelectByInsertingWithEntityName() {
        if (this._canSelectByInsertingWithEntityName == 0) {
            this._canSelectByInsertingWithEntityName = EOControllerFactory.sharedControllerFactory().canSelectByInsertingWithEntityName(this.entityName()) ? 1 : 2;
        }
        return this._canSelectByInsertingWithEntityName == 1;
    }

    protected boolean _relationshipPathRepresentsToOneRelationship() {
        if (this._relationshipPathRepresentsToOneRelationship == 0) {
            String relationshipPath = this.relationshipPath();
            this._relationshipPathRepresentsToOneRelationship = relationshipPath != null && _EOKeyPathUtility.utility().keyPathRepresentsToOneRelationship(this._masterEntityName(), relationshipPath) ? 1 : 2;
        }
        return this._relationshipPathRepresentsToOneRelationship == 1;
    }

    protected boolean _relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject() {
        if (this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject == 0) {
            String relationshipPath = this.relationshipPath();
            this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject = relationshipPath != null && _EOKeyPathUtility.utility().keyPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject(this._masterEntityName(), relationshipPath) ? 1 : 2;
        }
        return this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject == 1;
    }

    private boolean _canOpenWithRelationshipPath() {
        if (this._canOpenWithRelationshipPath == 0) {
            boolean canOpen = false;
            String relationshipPath = this.relationshipPath();
            if (relationshipPath != null) {
                canOpen = this._canOpenGlobalIDsWithEntityName() ? true : this._filteredMandatoryRelationshipPathsForOpeningToEntityNamesMapTable(this.mandatoryRelationshipPaths(), this._masterEntityName(), relationshipPath).count() > 0;
            }
            this._canOpenWithRelationshipPath = canOpen ? 1 : 2;
        }
        return this._canOpenWithRelationshipPath == 1;
    }

    public void setEntityName(String string) {
        this._canOpenWithRelationshipPath = 0;
        this._canSelectByInsertingWithEntityName = 0;
        this._canOpenWithEntityName = 0;
        this._canOpenGlobalIDsWithEntityName = 0;
        this._canInsertWithEntityName = 0;
        this._canSelectWithEntityName = 0;
        super.setEntityName(string);
    }

    public String entityName() {
        String relationshipPath = this.relationshipPath();
        if (relationshipPath != null) {
            if (this._derivedEntityName != null) {
                return this._derivedEntityName;
            }
            String entityName = _EOKeyPathUtility.utility().destinationEntityNameForKeyPath(this._masterEntityName(), this.relationshipPath());
            this._derivedEntityName = this.isConnected() ? entityName : null;
            this._canSelectByInsertingWithEntityName = 0;
            this._canOpenWithEntityName = 0;
            this._canOpenGlobalIDsWithEntityName = 0;
            this._canInsertWithEntityName = 0;
            this._canSelectWithEntityName = 0;
            return entityName;
        }
        return super.entityName();
    }

    protected String _derivedLabel() {
        String relationshipPath = this.relationshipPath();
        return relationshipPath != null ? EODisplayUtilities.localizedDisplayLabelForString((String)relationshipPath) : super._derivedLabel();
    }

    protected EODisplayGroup _defaultDisplayGroup() {
        return this.relationshipPath() != null ? null : super._defaultDisplayGroup();
    }

    public EODisplayGroup newDisplayGroup() {
        if (this.relationshipPath() != null) {
            EODisplayGroup displayGroup = new EODisplayGroup();
            displayGroup.setFetchesOnLoad(false);
            displayGroup.setSelectsFirstObjectAfterFetch(true);
            displayGroup.setUsesOptimisticRefresh(false);
            displayGroup.setSortOrderings(this.displayGroupSortOrderings());
            this._addToDisposableRegistry((NSDisposable)displayGroup);
            return displayGroup;
        }
        return super.newDisplayGroup();
    }

    private EOEnterpriseObject _masterObject() {
        EODisplayGroup masterDisplayGroup = this._masterDisplayGroup();
        if (masterDisplayGroup != null) {
            return (EOEnterpriseObject)masterDisplayGroup.selectedObject();
        }
        return null;
    }

    private String _masterEntityName() {
        String entityName = (String)this._hierarchicalValueForKey(EOObjectDisplay._CLASS, "entityName", true);
        if (entityName == null) {
            this._raiseBecauseOfMissingSupercontroller(EOObjectDisplay._CLASS, "retrieve the master entity name", null);
        }
        return entityName;
    }

    private EODisplayGroup _masterDisplayGroup() {
        EODisplayGroup displayGroup = (EODisplayGroup)this._hierarchicalValueForKey(EOObjectDisplay._CLASS, "displayGroup", true);
        if (displayGroup == null) {
            this._raiseBecauseOfMissingSupercontroller(EOObjectDisplay._CLASS, "retrieve the master display group", null);
        }
        return displayGroup;
    }

    public void setMasterDetailAssociation(EOMasterDetailAssociation association) {
        this._masterDetailAssociation = association;
    }

    public EOMasterDetailAssociation masterDetailAssociation() {
        String key = this.relationshipPath();
        EODisplayGroup displayGroup = this.displayGroup();
        if (this._masterDetailAssociation == null && key != null && displayGroup != null) {
            EODisplayGroup masterDisplayGroup = this._masterDisplayGroup();
            EOMasterDetailAssociation association = new EOMasterDetailAssociation((Object)displayGroup);
            association.bindAspect("parent", masterDisplayGroup, key);
            this.setMasterDetailAssociation(association);
        }
        return this._masterDetailAssociation;
    }

    protected NSArray defaultActions() {
        NSMutableArray actions = null;
        String relationshipPath = this.relationshipPath();
        if (EOUserInterfaceParameters._showDefaultDocumentActionsInWindows && relationshipPath != null) {
            actions = new NSMutableArray();
            if (this.isEditable()) {
                if (this._relationshipPathRepresentsToOneRelationship()) {
                    if (!this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject()) {
                        if (this._canSelectWithEntityName()) {
                            actions.addObject((Object)EOAction.standardSelectActionForControllerHierarchy());
                            actions.addObject((Object)EOAction.standardDeselectActionForControllerHierarchy());
                        } else {
                            actions.addObject((Object)EOAction.standardAddActionForControllerHierarchy());
                            actions.addObject((Object)EOAction.standardRemoveActionForControllerHierarchy());
                        }
                    }
                } else {
                    actions.addObject((Object)EOAction.standardAddActionForControllerHierarchy());
                    actions.addObject((Object)EOAction.standardRemoveActionForControllerHierarchy());
                }
            }
            if (this._canOpenWithRelationshipPath() && !this._isUsedInModalContext()) {
                actions.addObject((Object)EOAction.standardOpenWithTaskActionForControllerHierarchy());
            }
        }
        return EOAction.mergedActions(actions, (NSArray)super.defaultActions());
    }

    public boolean canPerformActionNamed(String actionName) {
        if (this.isActionNamedEnabled(actionName)) {
            String relationshipPath = this.relationshipPath();
            if (relationshipPath != null) {
                if (actionName.equals("insert")) {
                    if (this.isEditable() && this._masterObject() != null) {
                        if (this._relationshipPathRepresentsToOneRelationship()) {
                            EODisplayGroup displayGroup = this.displayGroup();
                            return displayGroup != null && (displayGroup.allObjects().count() <= 0 || this._canSelectWithEntityName());
                        }
                        return true;
                    }
                    return false;
                }
                if (actionName.equals("delete")) {
                    return this.isEditable() && this._numberOfSelectedObjects() > 0 && this._masterObject() != null;
                }
                if (actionName.equals("openWithTask")) {
                    return this._numberOfSelectedObjects() > 0 && this._canOpenWithRelationshipPath();
                }
            }
            return super.canPerformActionNamed(actionName);
        }
        return false;
    }

    private NSDictionary _filteredMandatoryRelationshipPathsForInsertionToEntityNamesMapTable(NSArray mandatoryRelationshipPaths, String ignoreEntityName, String ignoreRelationshipPath, NSDictionary prefilledRelationshipPathsToGlobalIDsMapTable) {
        NSMutableDictionary mandatoryRelationshipPathsToEntityNamesMapTable = new NSMutableDictionary();
        String entityName = this.entityName();
        if (entityName != null && mandatoryRelationshipPaths != null) {
            _EOKeyPathUtility utility = _EOKeyPathUtility.utility();
            int count = mandatoryRelationshipPaths.count();
            for (int i = 0; i < count; ++i) {
                String inverseRelationshipPath;
                String relationshipPath = (String)mandatoryRelationshipPaths.objectAtIndex(i);
                String destinationEntityName = utility.destinationEntityNameForKeyPath(entityName, relationshipPath);
                if (destinationEntityName == null || ignoreEntityName != null && destinationEntityName.equals(ignoreEntityName) && (ignoreRelationshipPath == null || (inverseRelationshipPath = utility.inverseKeyPath(entityName, relationshipPath)) != null && inverseRelationshipPath.equals(ignoreRelationshipPath)) || prefilledRelationshipPathsToGlobalIDsMapTable != null && prefilledRelationshipPathsToGlobalIDsMapTable.objectForKey((Object)relationshipPath) != null || !EOControllerFactory.sharedControllerFactory().canSelectWithEntityName(destinationEntityName)) continue;
                mandatoryRelationshipPathsToEntityNamesMapTable.setObjectForKey((Object)destinationEntityName, (Object)relationshipPath);
            }
        }
        return mandatoryRelationshipPathsToEntityNamesMapTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _insertWithFillingRelationships(String ignoreEntityName, NSDictionary prefilledRelationshipPathsToGlobalIDsMapTable, boolean canInsertMultipleObjects) {
        EOEditingContext editingContext = this.editingContext();
        NSUndoManager undoManager = this._editingContextUndoManager();
        if (editingContext != null) {
            NSArray globalIDs;
            int i;
            String relationshipPath;
            NSDictionary mandatoryRelationshipPathsToEntityNamesMapTable;
            NSArray relationshipPaths;
            int count;
            _EOKeyPathUtility utility = _EOKeyPathUtility.utility();
            String entityName = this.entityName();
            NSMutableDictionary relationshipPathsToGlobalIDsMapTable = new NSMutableDictionary();
            if (prefilledRelationshipPathsToGlobalIDsMapTable != null) {
                relationshipPathsToGlobalIDsMapTable.addEntriesFromDictionary(prefilledRelationshipPathsToGlobalIDsMapTable);
            }
            if ((count = (relationshipPaths = (mandatoryRelationshipPathsToEntityNamesMapTable = this._filteredMandatoryRelationshipPathsForInsertionToEntityNamesMapTable(this.mandatoryRelationshipPaths(), ignoreEntityName, this.relationshipPath(), prefilledRelationshipPathsToGlobalIDsMapTable)).allKeys()).count()) == 1) {
                relationshipPath = (String)relationshipPaths.objectAtIndex(0);
                if (canInsertMultipleObjects && utility.keyPathRepresentsToOneRelationship(entityName, relationshipPath)) {
                    String destinationEntityName = (String)mandatoryRelationshipPathsToEntityNamesMapTable.objectForKey((Object)relationshipPath);
                    NSArray globalIDs2 = EOControllerFactory.sharedControllerFactory().selectWithEntityName(destinationEntityName, true, true);
                    if (globalIDs2 != null && (count = globalIDs2.count()) > 0) {
                        if (undoManager != null) {
                            undoManager.beginUndoGrouping();
                        }
                        boolean success = true;
                        try {
                            for (int i2 = 0; i2 < count && success; ++i2) {
                                EOEnterpriseObject objectForGlobalID = editingContext.faultForGlobalID((EOGlobalID)globalIDs2.objectAtIndex(i2), editingContext);
                                if (objectForGlobalID != null) {
                                    this.insertObject();
                                    EOEnterpriseObject insertedObject = this.selectedObject();
                                    if (insertedObject == null) continue;
                                    insertedObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)objectForGlobalID, relationshipPath);
                                    continue;
                                }
                                success = false;
                            }
                        }
                        finally {
                            editingContext.processRecentChanges();
                            if (undoManager != null) {
                                undoManager.endUndoGrouping();
                            }
                        }
                        if (!success && undoManager != null) {
                            undoManager.undo();
                        }
                        return success;
                    }
                    return false;
                }
                if (!canInsertMultipleObjects && utility.keyPathRepresentsToManyRelationship(entityName, relationshipPath)) {
                    String destinationEntityName = (String)mandatoryRelationshipPathsToEntityNamesMapTable.objectForKey((Object)relationshipPath);
                    NSArray globalIDs3 = EOControllerFactory.sharedControllerFactory().selectWithEntityName(destinationEntityName, true, true);
                    if (globalIDs3 != null && (count = globalIDs3.count()) > 0) {
                        if (undoManager != null) {
                            undoManager.beginUndoGrouping();
                        }
                        boolean success = true;
                        try {
                            for (int i3 = 0; i3 < count && success; ++i3) {
                                EOEnterpriseObject objectForGlobalID = editingContext.faultForGlobalID((EOGlobalID)globalIDs3.objectAtIndex(i3), editingContext);
                                if (objectForGlobalID == null) continue;
                                this.insertObject();
                                EOEnterpriseObject insertedObject = this.selectedObject();
                                if (insertedObject == null) continue;
                                insertedObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)objectForGlobalID, relationshipPath);
                            }
                        }
                        finally {
                            editingContext.processRecentChanges();
                            if (undoManager != null) {
                                undoManager.endUndoGrouping();
                            }
                        }
                        if (!success && undoManager != null) {
                            undoManager.undo();
                        }
                        return success;
                    }
                    return false;
                }
            }
            for (i = 0; i < count; ++i) {
                relationshipPath = (String)relationshipPaths.objectAtIndex(i);
                String destinationEntityName = (String)mandatoryRelationshipPathsToEntityNamesMapTable.objectForKey((Object)relationshipPath);
                globalIDs = EOControllerFactory.sharedControllerFactory().selectWithEntityName(destinationEntityName, utility.keyPathRepresentsToManyRelationship(entityName, relationshipPath), true);
                if (globalIDs == null) {
                    return false;
                }
                if (globalIDs.count() <= 0) continue;
                relationshipPathsToGlobalIDsMapTable.setObjectForKey((Object)globalIDs, (Object)relationshipPath);
            }
            if (undoManager != null) {
                undoManager.beginUndoGrouping();
            }
            boolean success = true;
            try {
                this.insertObject();
                EOEnterpriseObject insertedObject = this.selectedObject();
                if (insertedObject != null) {
                    relationshipPaths = relationshipPathsToGlobalIDsMapTable.allKeys();
                    count = relationshipPaths.count();
                    for (i = 0; i < count && success; ++i) {
                        relationshipPath = (String)relationshipPaths.objectAtIndex(i);
                        globalIDs = (NSArray)relationshipPathsToGlobalIDsMapTable.objectForKey((Object)relationshipPath);
                        int numberOfGlobalIDs = globalIDs.count();
                        for (int j = 0; j < numberOfGlobalIDs; ++j) {
                            EOEnterpriseObject objectForGlobalID = editingContext.faultForGlobalID((EOGlobalID)globalIDs.objectAtIndex(j), editingContext);
                            if (objectForGlobalID == null) continue;
                            insertedObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)objectForGlobalID, relationshipPath);
                        }
                    }
                }
            }
            finally {
                editingContext.processRecentChanges();
                if (undoManager != null) {
                    undoManager.endUndoGrouping();
                }
            }
            if (!success && undoManager != null) {
                undoManager.undo();
            }
            return success;
        }
        return false;
    }

    public boolean insert() {
        String relationshipPath = this.relationshipPath();
        if (this.relationshipPath() != null && this.isEditable() && this._masterObject() != null) {
            boolean isToOneRelationship = this._relationshipPathRepresentsToOneRelationship();
            EODisplayGroup displayGroup = this.displayGroup();
            if (this._canSelectWithEntityName()) {
                int count;
                NSArray globalIDs;
                EOEditingContext editingContext = this.editingContext();
                if (editingContext != null && displayGroup != null && (globalIDs = EOControllerFactory.sharedControllerFactory().selectWithEntityName(this.entityName(), !isToOneRelationship, true)) != null && (count = globalIDs.count()) > 0) {
                    int index;
                    if (isToOneRelationship) {
                        index = displayGroup.allObjects().count() - 1;
                        while (index >= 0) {
                            displayGroup.deleteObjectAtIndex(index--);
                        }
                    }
                    index = displayGroup.allObjects().count();
                    for (int i = 0; i < count; ++i) {
                        EOEnterpriseObject objectForGlobalID = editingContext.faultForGlobalID((EOGlobalID)globalIDs.objectAtIndex(i), editingContext);
                        if (objectForGlobalID == null) continue;
                        displayGroup.insertObjectAtIndex((Object)objectForGlobalID, index++);
                    }
                    return true;
                }
                return false;
            }
            if (!isToOneRelationship || displayGroup.allObjects().count() <= 0) {
                return this._insertWithFillingRelationships(this._masterEntityName(), null, !isToOneRelationship);
            }
        }
        return false;
    }

    protected boolean _deleteIfNoRelationshipPath(boolean saveImmediately, boolean makeInvisibleAfterImmediateSave) {
        if (this.relationshipPath() == null) {
            int numberOfGlobalIDs;
            NSArray globalIDs = this.selectedObjectsGlobalIDs();
            int n = numberOfGlobalIDs = globalIDs != null ? globalIDs.count() : 0;
            if (numberOfGlobalIDs > 0) {
                int i;
                EOControllerFactory factory = EOControllerFactory.sharedControllerFactory();
                NSMutableArray controllers = new NSMutableArray();
                for (i = 0; i < numberOfGlobalIDs; ++i) {
                    NSArray documentsForGlobalID = EOApplication.sharedApplication().documentsForGlobalID((EOGlobalID)globalIDs.objectAtIndex(i), this.entityName());
                    if (documentsForGlobalID == null) continue;
                    controllers.addObjectsFromArray(documentsForGlobalID);
                }
                boolean otherEditedDocumentsAvailable = false;
                int numberOfControllers = controllers.count();
                for (i = 0; i < numberOfControllers; ++i) {
                    EODocument document = (EODocument)controllers.objectAtIndex(i);
                    if (document == this || !document.isEdited()) continue;
                    otherEditedDocumentsAvailable = true;
                    break;
                }
                String deleteString = EOUserInterfaceParameters.localizedString((String)"Delete");
                if (otherEditedDocumentsAvailable) {
                    EODialogs.runInformationDialog((String)deleteString, (String)(EOUserInterfaceParameters.localizedString((String)(numberOfGlobalIDs == 1 ? "First close or revert all documents for the selected object" : "First close or revert all documents for the selected objects")) + EOUserInterfaceParameters._localizedBang()));
                    return false;
                }
                if (saveImmediately && !EODialogs.runConfirmOperationDialog((String)deleteString, (String)(EOUserInterfaceParameters.localizedString((String)(numberOfGlobalIDs == 1 ? "Do you really want to delete the selected object" : "Do you really want to delete the selected objects")) + " " + EOUserInterfaceParameters._localizedOpenBracket() + EOUserInterfaceParameters.localizedString((String)"this operation cannot be undone") + EOUserInterfaceParameters._localizedCloseBracket() + EOUserInterfaceParameters._localizedQuestionMark()), (String)deleteString)) {
                    return false;
                }
                this.deleteSelectedObjects();
                if (saveImmediately) {
                    if (this.saveChanges(true, deleteString)) {
                        for (i = 0; i < numberOfControllers; ++i) {
                            EOController controller = (EOController)controllers.objectAtIndex(i);
                            if (controller == this || !(controller instanceof EOComponentController)) continue;
                            ((EOComponentController)controller).makeInvisible();
                        }
                        if (makeInvisibleAfterImmediateSave) {
                            this.makeInvisible();
                        }
                    } else {
                        EOEditingContext editingContext = this.editingContext();
                        if (editingContext != null) {
                            editingContext.undo();
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean delete() {
        String relationshipPath = this.relationshipPath();
        if (relationshipPath != null && this.isEditable() && this._masterObject() != null && this._numberOfSelectedObjects() > 0 && !this._relationshipPathRepresentsToOneRelationshipWithAutomaticallyCreatedObject()) {
            this.deleteSelectedObjects();
            return true;
        }
        return false;
    }

    private NSDictionary _filteredMandatoryRelationshipPathsForOpeningToEntityNamesMapTable(NSArray mandatoryRelationshipPaths, String ignoreEntityName, String ignoreRelationshipPath) {
        NSMutableDictionary mandatoryRelationshipPathsToEntityNamesMapTable = new NSMutableDictionary();
        String entityName = this.entityName();
        if (entityName != null && mandatoryRelationshipPaths != null) {
            _EOKeyPathUtility utility = _EOKeyPathUtility.utility();
            int count = mandatoryRelationshipPaths.count();
            for (int i = 0; i < count; ++i) {
                String inverseRelationshipPath;
                String relationshipPath = (String)mandatoryRelationshipPaths.objectAtIndex(i);
                String destinationEntityName = utility.destinationEntityNameForKeyPath(entityName, relationshipPath);
                if (destinationEntityName == null || ignoreEntityName != null && destinationEntityName.equals(ignoreEntityName) && (ignoreRelationshipPath == null || (inverseRelationshipPath = utility.inverseKeyPath(entityName, relationshipPath)) != null && inverseRelationshipPath.equals(ignoreRelationshipPath)) || !EOControllerFactory.sharedControllerFactory().canOpenGlobalIDsWithEntityName(destinationEntityName)) continue;
                mandatoryRelationshipPathsToEntityNamesMapTable.setObjectForKey((Object)destinationEntityName, (Object)relationshipPath);
            }
        }
        return mandatoryRelationshipPathsToEntityNamesMapTable;
    }

    protected boolean _openSelectedObjectsWithTask(String ignoreEntityName) {
        NSArray globalIDs = this.selectedObjectsGlobalIDs();
        if (globalIDs != null && globalIDs.count() > 0 && this._canOpenGlobalIDsWithEntityName()) {
            EOControllerFactory.sharedControllerFactory().openGlobalIDsWithEntityName(this.entityName(), globalIDs);
            return true;
        }
        EOEditingContext editingContext = this.editingContext();
        NSArray objects = this.selectedObjects();
        if (editingContext != null && objects != null && objects.count() > 0) {
            boolean success = false;
            NSMutableArray destinationGlobalIDs = new NSMutableArray();
            NSDictionary mandatoryRelationshipPathsToEntityNamesMapTable = this._filteredMandatoryRelationshipPathsForOpeningToEntityNamesMapTable(this.mandatoryRelationshipPaths(), ignoreEntityName, this.relationshipPath());
            NSArray relationshipPaths = mandatoryRelationshipPathsToEntityNamesMapTable.allKeys();
            int count = relationshipPaths.count();
            for (int i = 0; i < count; ++i) {
                String relationshipPath = (String)relationshipPaths.objectAtIndex(i);
                String destinationEntityName = (String)mandatoryRelationshipPathsToEntityNamesMapTable.objectForKey((Object)relationshipPath);
                destinationGlobalIDs.removeAllObjects();
                int index = objects.count() - 1;
                while (index >= 0) {
                    EOEnterpriseObject object = (EOEnterpriseObject)objects.objectAtIndex(index--);
                    try {
                        EOGlobalID globalID;
                        EOEnterpriseObject destinationObject;
                        Object value = object.valueForKeyPath(relationshipPath);
                        if (value == null) continue;
                        if (value instanceof NSArray) {
                            NSArray destinationObjects = (NSArray)value;
                            int numberOfDestinationObjects = destinationObjects.count();
                            for (int j = 0; j < numberOfDestinationObjects; ++j) {
                                destinationObject = (EOEnterpriseObject)destinationObjects.objectAtIndex(j);
                                globalID = editingContext.globalIDForObject(destinationObject);
                                if (globalID == null) continue;
                                destinationGlobalIDs.addObject((Object)globalID);
                            }
                            continue;
                        }
                        destinationObject = (EOEnterpriseObject)value;
                        globalID = editingContext.globalIDForObject(destinationObject);
                        if (globalID == null) continue;
                        destinationGlobalIDs.addObject((Object)globalID);
                    }
                    catch (Throwable throwable) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)2L)) continue;
                        NSLog.debug.appendln((Object)("Error Opening Objects: " + throwable.getMessage()));
                        NSLog.debug.appendln(throwable);
                    }
                }
                if (destinationGlobalIDs.count() <= 0) continue;
                EOControllerFactory.sharedControllerFactory().openGlobalIDsWithEntityName(destinationEntityName, (NSArray)destinationGlobalIDs);
                success = true;
            }
            return success;
        }
        return false;
    }

    public boolean openWithTask() {
        return this.relationshipPath() != null ? this._openSelectedObjectsWithTask(this._masterEntityName()) : false;
    }

    protected void _finishModalAction() {
        EOComponentController.Modal modalController = this._controllerCreatingModalContext();
        if (modalController != null) {
            modalController.finishModal();
        } else {
            this.makeInvisible();
        }
    }

    public String toString() {
        String string = super.toString();
        if (this._relationshipPath != null) {
            string = string + ", relationship path = " + this._relationshipPath;
        }
        return string;
    }
}

