/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOArchive;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication.EOEntityController;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOXMLUnarchiver;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.eogeneration.EOQueryObjectDisplay;
import com.webobjects.eogeneration.EOWidgetController;
import com.webobjects.eointerface.EODisplayGroup;
import com.webobjects.eointerface.swing.EOSwingUtilities;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EOQueryController
extends EOEntityController
implements ActionListener,
EOWidgetController.DefaultAction,
EOWidgetController.DefaultAction.CommonWidgetHandler,
EOControllerFactory.Query,
EOQueryObjectDisplay {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOQueryController");
    private EOEditingContext _queryEditingContext = null;
    private EODisplayGroup _queryDisplayGroup = null;
    private boolean _fetchesAdditionalQueryDisplayGroupsOnConnect = true;
    private NSMutableArray _additionalQueryDisplayGroups = null;
    private boolean _runsConfirmDialogForEmptyQualifiers = true;
    private NSMutableArray _defaultActionWidgets = null;

    public EOQueryController() {
    }

    public EOQueryController(EOXMLUnarchiver unarchiver) {
        super(unarchiver);
        this.setRunsConfirmDialogForEmptyQualifiers(unarchiver.decodeBooleanForKey("runsConfirmDialogForEmptyQualifiers", true));
    }

    public NSMutableDictionary _xmlParameters() {
        NSMutableDictionary parameters = super._xmlParameters();
        if (!this._runsConfirmDialogForEmptyQualifiers) {
            parameters.setObjectForKey((Object)(this._runsConfirmDialogForEmptyQualifiers ? Boolean.TRUE : Boolean.FALSE), (Object)"runsConfirmDialogForEmptyQualifiers");
        }
        return parameters;
    }

    public void dispose() {
        super.dispose();
        this.setQueryEditingContext(null);
        this.setQueryDisplayGroup(null);
        this._additionalQueryDisplayGroups = null;
        if (this._defaultActionWidgets != null) {
            int count = this._defaultActionWidgets.count();
            for (int i = 0; i < count; ++i) {
                Object actionWidget = this._defaultActionWidgets.objectAtIndex(i);
                if (actionWidget instanceof JTextField) {
                    ((JTextField)actionWidget).removeActionListener(this);
                    continue;
                }
                if (actionWidget instanceof AbstractButton) {
                    ((AbstractButton)actionWidget).removeActionListener(this);
                    continue;
                }
                if (!(actionWidget instanceof JComboBox)) continue;
                ((JComboBox)actionWidget).removeActionListener(this);
            }
        }
    }

    protected void _lightPrepareForNewTask() {
        this._prepareObjectDisplayForNewTask(true);
        EOController.Enumeration controllerEnumeration = this.controllerEnumeration(1, null);
        while (controllerEnumeration.hasMoreElements()) {
            EOController controller = controllerEnumeration.nextController();
            if (controller instanceof EOWidgetController.QueryWidget) continue;
            controller.prepareForNewTask(false);
        }
    }

    public void prepareForNewTask(boolean prepareSubcontrollersForNewTask) {
        EOEditingContext editingContext;
        super.prepareForNewTask(prepareSubcontrollersForNewTask);
        boolean isConnected = this.isConnected();
        if (!isConnected) {
            this._fetchesAdditionalQueryDisplayGroupsOnConnect = true;
            if (this._additionalQueryDisplayGroups != null) {
                int count = this._additionalQueryDisplayGroups.count();
                for (int i = 0; i < count; ++i) {
                    ((EODisplayGroup)this._additionalQueryDisplayGroups.objectAtIndex(i)).setObjectArray(null);
                }
            }
        }
        if ((editingContext = this._queryEditingContextOptimizedOfNeverBeenVisible()) != null) {
            editingContext.revert();
            editingContext.refaultAllObjects();
            if (this.resetsEditingContextWhenPreparingForNewTask() && !isConnected) {
                editingContext.reset();
            }
        }
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        if (this._fetchesAdditionalQueryDisplayGroupsOnConnect) {
            this._fetchesAdditionalQueryDisplayGroupsOnConnect = false;
            if (this._additionalQueryDisplayGroups != null) {
                int count = this._additionalQueryDisplayGroups.count();
                for (int i = 0; i < count; ++i) {
                    EODisplayGroup displayGroup = (EODisplayGroup)this._additionalQueryDisplayGroups.objectAtIndex(i);
                    displayGroup.fetch();
                }
            }
        }
    }

    protected void controllerDidLoadArchive(NSDictionary namedObjects) {
        if (namedObjects != null) {
            this._additionalQueryDisplayGroups = this._fetchOnLoadDisplayGroupsInObjects(namedObjects.allValues(), this.queryEditingContext(), this._additionalQueryDisplayGroups);
        }
    }

    public Object objectForOutletPath(EOArchive archive, String outletPath) {
        if (outletPath != null) {
            if (outletPath.equals("queryEditingContext")) {
                return this.queryEditingContext();
            }
            if (outletPath.equals("queryDisplayGroup")) {
                return this.queryDisplayGroup();
            }
        }
        return super.objectForOutletPath(archive, outletPath);
    }

    public EOEditingContext newQueryEditingContext() {
        EOEditingContext editingContext = new EOEditingContext();
        this._addToDisposableRegistry((NSDisposable)editingContext);
        return editingContext;
    }

    public void setQueryEditingContext(EOEditingContext editingContext) {
        this._queryEditingContext = editingContext;
    }

    public EOEditingContext queryEditingContext() {
        if (this._queryEditingContext == null) {
            this.setQueryEditingContext(this.newQueryEditingContext());
        }
        return this._queryEditingContext;
    }

    protected EOEditingContext _queryEditingContextOptimizedOfNeverBeenVisible() {
        return this._hasEverBeenVisible() ? this.queryEditingContext() : this._queryEditingContext;
    }

    public EODataSource newQueryDataSource() {
        return this._newDataSource(this.queryEditingContext());
    }

    public EODisplayGroup newQueryDisplayGroup() {
        return this._newDisplayGroup(this.newQueryDataSource());
    }

    public void setQueryDisplayGroup(EODisplayGroup displayGroup) {
        this._queryDisplayGroup = displayGroup;
    }

    public EODisplayGroup queryDisplayGroup() {
        if (this._queryDisplayGroup == null) {
            this.setQueryDisplayGroup(this.newQueryDisplayGroup());
        }
        return this._queryDisplayGroup;
    }

    protected EODisplayGroup _queryDisplayGroupOptimizedOfNeverBeenVisible() {
        return this._hasEverBeenVisible() ? this.queryDisplayGroup() : this._queryDisplayGroup;
    }

    public EOQualifier qualifier() {
        this.endEditing();
        EODisplayGroup displayGroup = this.queryDisplayGroup();
        return displayGroup != null ? displayGroup.qualifierFromQueryValues() : null;
    }

    public EOFetchSpecification fetchSpecification() {
        return new EOFetchSpecification(this.entityName(), this.qualifier(), null, false, true, null);
    }

    public boolean fetchesOnConnect() {
        return false;
    }

    public boolean endEditing() {
        EODisplayGroup displayGroup = this._queryDisplayGroupOptimizedOfNeverBeenVisible();
        if (displayGroup != null && !displayGroup.endEditing()) {
            return false;
        }
        if (this._additionalQueryDisplayGroups != null) {
            int count = this._additionalQueryDisplayGroups.count();
            for (int i = 0; i < count; ++i) {
                if (((EODisplayGroup)this._additionalQueryDisplayGroups.objectAtIndex(i)).endEditing()) continue;
                return false;
            }
        }
        return super.endEditing();
    }

    public void setRunsConfirmDialogForEmptyQualifiers(boolean flag) {
        this._runsConfirmDialogForEmptyQualifiers = flag;
    }

    public boolean runsConfirmDialogForEmptyQualifiers() {
        return this._runsConfirmDialogForEmptyQualifiers;
    }

    protected NSArray defaultActions() {
        NSMutableArray actions = new NSMutableArray(3);
        actions.addObject((Object)EOAction.standardFindActionForControllerHierarchy());
        actions.addObject((Object)EOAction.standardAppendActionForControllerHierarchy());
        actions.addObject((Object)EOAction.standardClearActionForControllerHierarchy());
        return EOAction.mergedActions((NSArray)actions, (NSArray)super.defaultActions());
    }

    public void defaultAction() {
        this.find();
    }

    public boolean canTakeResposibilityForDefaultActionWithActionWidget(JComponent actionWidget) {
        return actionWidget instanceof JTextField || actionWidget instanceof AbstractButton || actionWidget instanceof JComboBox;
    }

    public void takeResposibilityForDefaultActionWithActionWidget(JComponent actionWidget) {
        if (actionWidget != null) {
            if (actionWidget instanceof JTextField) {
                ((JTextField)actionWidget).addActionListener(this);
            } else if (actionWidget instanceof AbstractButton) {
                ((AbstractButton)actionWidget).addActionListener(this);
            } else if (actionWidget instanceof JComboBox) {
                ((JComboBox)actionWidget).addActionListener(this);
            }
            if (this._defaultActionWidgets == null) {
                this._defaultActionWidgets = new NSMutableArray(8);
            }
            this._defaultActionWidgets.addObject((Object)actionWidget);
        }
    }

    private void _search(EOFetchSpecification fetchSpecification, boolean append, boolean checkWithUserIfEmptyQualifier) {
        String findString = EOUserInterfaceParameters.localizedString((String)"Find");
        if (!EODocumentController._saveChangesIfEditedIfUserConfirms((EOController)this, (String)findString)) {
            return;
        }
        EOEditingContext editingContext = this.editingContext();
        if (fetchSpecification != null && editingContext != null) {
            EOQualifier qualifier;
            if (checkWithUserIfEmptyQualifier && (qualifier = fetchSpecification.qualifier()) == null && !EODialogs.runConfirmOperationDialog((String)findString, (String)(EOUserInterfaceParameters.localizedString((String)"Do you really want to search for all objects") + EOUserInterfaceParameters._localizedQuestionMark()), (String)findString)) {
                return;
            }
            if (!append && this.isRootEntityController()) {
                this._lightPrepareForNewTask();
            }
            NSArray objects = editingContext.objectsWithFetchSpecification(fetchSpecification);
            EODisplayGroup displayGroup = this.displayGroup();
            if (displayGroup != null) {
                if (append) {
                    NSArray additionalObjects;
                    NSMutableArray appendedObjects = new NSMutableArray();
                    NSArray currentObjects = displayGroup.allObjects();
                    if (currentObjects.count() > objects.count()) {
                        appendedObjects.addObjectsFromArray(currentObjects);
                        additionalObjects = objects;
                    } else {
                        appendedObjects.addObjectsFromArray(objects);
                        additionalObjects = currentObjects;
                    }
                    int count = additionalObjects.count();
                    for (int i = 0; i < count; ++i) {
                        Object object = additionalObjects.objectAtIndex(i);
                        if (appendedObjects.containsObject(object)) continue;
                        appendedObjects.addObject(object);
                    }
                    objects = appendedObjects;
                }
                this._abortEditing();
                displayGroup.setObjectArray(objects);
            }
        }
    }

    public void find() {
        this._search(this.fetchSpecification(), false, this.runsConfirmDialogForEmptyQualifiers());
    }

    public void append() {
        this._search(this.fetchSpecification(), true, this.runsConfirmDialogForEmptyQualifiers());
    }

    public void findAll() {
        this._search(new EOFetchSpecification(this.entityName(), null, null, false, true, null), true, false);
    }

    public void clear() {
        EODisplayGroup displayGroup = this.queryDisplayGroup();
        if (displayGroup != null) {
            displayGroup.setGreaterThanQueryValues(NSDictionary.EmptyDictionary);
            displayGroup.setLessThanQueryValues(NSDictionary.EmptyDictionary);
            displayGroup.setEqualToQueryValues(NSDictionary.EmptyDictionary);
            displayGroup.setQueryOperatorValues(NSDictionary.EmptyDictionary);
            displayGroup.setQueryBindingValues(NSDictionary.EmptyDictionary);
        }
    }

    public void queryObjectsWithFetchSpecification(EOFetchSpecification fetchSpecification) {
        this._prepareSpecialTask(true, false);
        this._search(fetchSpecification, false, false);
    }

    public void actionPerformed(ActionEvent event) {
        this.defaultAction();
        EOSwingUtilities.eventEnded();
    }
}

