/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOXMLUnarchiver;
import com.webobjects.eogeneration.EODefaultActionTrigger;
import com.webobjects.eointerface.EOAssociation;
import com.webobjects.eointerface.EODisplayGroup;
import com.webobjects.eointerface.EOTreeAssociation;
import com.webobjects.eointerface.swing.EOSwingTreePlugin;
import com.webobjects.eointerface.swing.EOSwingUtilities;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSUtilities;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class EOTreeController
extends EODefaultActionTrigger
implements TreeSelectionListener {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOTreeController");
    private JTree _tree;
    private String _childrenKey = null;
    private String _isLeafKey = null;
    private String _rootKey = null;
    private String _valueKey = null;
    private String _iconKey = null;
    private String _expandedIconKey = null;
    private String _parentKey = null;
    private boolean _isRootVisible = false;
    private boolean _allowsMultipleSelection = true;
    private boolean _allowsDiscontiguousSelection = true;

    public EOTreeController() {
    }

    public EOTreeController(EOXMLUnarchiver unarchiver) {
        super(unarchiver);
        this.setChildrenKey(unarchiver.decodeStringForKey("childrenKey"));
        this.setIsLeafKey(unarchiver.decodeStringForKey("isLeafKey"));
        this.setRootKey(unarchiver.decodeStringForKey("rootKey"));
        this.setValueKey(unarchiver.decodeStringForKey("valueKey"));
        this.setIconKey(unarchiver.decodeStringForKey("iconKey"));
        this.setExpandedIconKey(unarchiver.decodeStringForKey("expandedIconKey"));
        this.setParentKey(unarchiver.decodeStringForKey("parentKey"));
        this.setRootVisible(unarchiver.decodeBooleanForKey("isRootVisible", false));
        this.setAllowsMultipleSelection(unarchiver.decodeBooleanForKey("allowsMultipleSelection", true));
        this.setAllowsDiscontiguousSelection(unarchiver.decodeBooleanForKey("allowsDiscontiguousSelection", true));
    }

    public NSMutableDictionary _xmlParameters() {
        NSMutableDictionary parameters = super._xmlParameters();
        if (!EOTreeController._isEmpty(this._childrenKey)) {
            parameters.setObjectForKey((Object)this._childrenKey, (Object)"childrenKey");
        }
        if (!EOTreeController._isEmpty(this._isLeafKey)) {
            parameters.setObjectForKey((Object)this._isLeafKey, (Object)"isLeafKey");
        }
        if (!EOTreeController._isEmpty(this._rootKey)) {
            parameters.setObjectForKey((Object)this._rootKey, (Object)"rootKey");
        }
        if (!EOTreeController._isEmpty(this._valueKey)) {
            parameters.setObjectForKey((Object)this._valueKey, (Object)"valueKey");
        }
        if (!EOTreeController._isEmpty(this._iconKey)) {
            parameters.setObjectForKey((Object)this._iconKey, (Object)"iconKey");
        }
        if (!EOTreeController._isEmpty(this._expandedIconKey)) {
            parameters.setObjectForKey((Object)this._expandedIconKey, (Object)"expandedIconKey");
        }
        if (!EOTreeController._isEmpty(this._parentKey)) {
            parameters.setObjectForKey((Object)this._parentKey, (Object)"parentKey");
        }
        if (this._isRootVisible) {
            parameters.setObjectForKey((Object)EOTreeController._booleanObject(this._isRootVisible), (Object)"isRootVisible");
        }
        if (!this._allowsMultipleSelection) {
            parameters.setObjectForKey((Object)EOTreeController._booleanObject(this._allowsMultipleSelection), (Object)"allowsMultipleSelection");
        }
        if (!this._allowsDiscontiguousSelection) {
            parameters.setObjectForKey((Object)EOTreeController._booleanObject(this._allowsDiscontiguousSelection), (Object)"allowsDiscontiguousSelection");
        }
        return parameters;
    }

    private static Boolean _booleanObject(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean _isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected int _labelComponentVerticalOffset() {
        return 2;
    }

    protected int preferredLabelComponentPosition() {
        return 1;
    }

    protected boolean preferredUsesLabelComponent() {
        return true;
    }

    protected int preferredWidgetAutosizingMask() {
        return 48;
    }

    protected boolean _preferredCanResizeVertically() {
        return true;
    }

    protected String _derivedLabel() {
        return EODisplayUtilities.localizedDisplayLabelForString((String)this.childrenKey());
    }

    public void setChildrenKey(String string) {
        this._childrenKey = string;
    }

    public String childrenKey() {
        return this._childrenKey;
    }

    public void setParentKey(String string) {
        this._parentKey = string;
    }

    public String parentKey() {
        return this._parentKey;
    }

    public void setIsLeafKey(String string) {
        this._isLeafKey = string;
    }

    public String isLeafKey() {
        return this._isLeafKey;
    }

    public void setRootKey(String string) {
        this._rootKey = string;
    }

    public String rootKey() {
        return this._rootKey;
    }

    public void setValueKey(String string) {
        this._valueKey = string;
    }

    public String valueKey() {
        return this._valueKey;
    }

    public void setIconKey(String string) {
        this._iconKey = string;
    }

    public String iconKey() {
        return this._iconKey;
    }

    public void setExpandedIconKey(String string) {
        this._expandedIconKey = string;
    }

    public String expandedIconKey() {
        return this._expandedIconKey;
    }

    public void setRootVisible(boolean flag) {
        this._isRootVisible = flag;
        if (this.isComponentPrepared()) {
            this.tree().setRootVisible(this._isRootVisible);
        }
    }

    public boolean isRootVisible() {
        return this._isRootVisible;
    }

    public void setAllowsMultipleSelection(boolean flag) {
        this._allowsMultipleSelection = flag;
        if (this.isComponentPrepared()) {
            this._setSelectionModel();
        }
    }

    public boolean allowsMultipleSelection() {
        return this._allowsMultipleSelection;
    }

    public void setAllowsDiscontiguousSelection(boolean flag) {
        this._allowsDiscontiguousSelection = flag;
        if (this.isComponentPrepared()) {
            this._setSelectionModel();
        }
    }

    public boolean allowsDiscontiguousSelection() {
        return this._allowsDiscontiguousSelection;
    }

    protected void _setSelectionModel() {
        JTree tree = this.tree();
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        if (_SelectionUtilities.isEmpty(selectionModel)) {
            selectionModel = new DefaultTreeSelectionModel();
        }
        int selectionMode = !this.allowsMultipleSelection() ? 1 : (!this.allowsDiscontiguousSelection() ? 2 : 4);
        selectionModel.setSelectionMode(selectionMode);
        tree.setSelectionModel(selectionModel);
    }

    public NSArray selectedObjects() {
        return _SelectionUtilities.objectsWithPaths(this.tree().getSelectionPaths());
    }

    public NSArray selectedObjectPaths() {
        return _SelectionUtilities.objectPathsForPaths(this.tree().getSelectionPaths());
    }

    public void setSelectedObjectWithNumericPath(NSArray newSelectedNumericPath) {
        JTree tree = this.tree();
        tree.setSelectionPath(_SelectionUtilities.pathForNumericPath(tree, newSelectedNumericPath));
    }

    public void setSelectedObjectsWithNumericPaths(NSArray newSelectedNumericPaths) {
        JTree tree = this.tree();
        tree.setSelectionPaths(_SelectionUtilities.pathsForNumericPaths(tree, newSelectedNumericPaths));
    }

    public void setSelectedObjectWithObjectPath(NSArray newSelectedObjectPath) {
        JTree tree = this.tree();
        tree.setSelectionPath(_SelectionUtilities.pathForObjectPath(tree, newSelectedObjectPath));
    }

    public void setSelectedObjectsWithObjectPaths(NSArray newSelectedObjectPaths) {
        JTree tree = this.tree();
        tree.setSelectionPaths(_SelectionUtilities.pathsForObjectPaths(tree, newSelectedObjectPaths));
    }

    public void setSelectedObject(Object newSelectedObject) {
        JTree tree = this.tree();
        tree.setSelectionPath(_SelectionUtilities.pathForObject(tree, newSelectedObject));
    }

    public void setSelectedObjects(NSArray newSelectedObjects) {
        JTree tree = this.tree();
        tree.setSelectionPaths(_SelectionUtilities.pathsForObjects(tree, newSelectedObjects));
    }

    public void setSelectedObjectWithParentKey(Object newSelectedObject) {
        JTree tree = this.tree();
        tree.setSelectionPath(_SelectionUtilities.pathForObjectWithParentKey(tree, newSelectedObject, this.parentKey()));
    }

    public void setSelectedObjectsWithParentKey(NSArray newSelectedObjects) {
        JTree tree = this.tree();
        tree.setSelectionPaths(_SelectionUtilities.pathsForObjectsWithParentKey(tree, newSelectedObjects, this.parentKey()));
    }

    protected void selectionDidChange(NSArray addedObjects, NSArray removedObjects) {
    }

    protected JComponent newWidget() {
        this._tree = new JTree();
        this.setRootVisible(this.isRootVisible());
        this.setAllowsMultipleSelection(this.allowsMultipleSelection());
        this.setAllowsDiscontiguousSelection(this.allowsDiscontiguousSelection());
        this._tree.setShowsRootHandles(true);
        this._tree.setFont(EOUserInterfaceParameters._widgetFont);
        JScrollPane scrollPane = new JScrollPane(this._tree);
        scrollPane.setSize(80, 60);
        return scrollPane;
    }

    protected void startListeningToWidget() {
        super.startListeningToWidget();
        this.tree().addTreeSelectionListener(this);
    }

    protected void stopListeningToWidget() {
        super.stopListeningToWidget();
        this.tree().removeTreeSelectionListener(this);
    }

    public JTree tree() {
        if (this._tree == null) {
            this._tree = _SelectionUtilities.treeView((JScrollPane)this.widget());
        }
        return this._tree;
    }

    protected JComponent mouseListenerViewInWidget() {
        return this.tree();
    }

    protected EOAssociation newAssociation(JComponent widget, EODisplayGroup displayGroup, String enabledKey, EODisplayGroup enabledDisplayGroup) {
        EOTreeAssociation association = new EOTreeAssociation((Object)_SelectionUtilities.treeView((JScrollPane)widget));
        association.bindAspect("children", displayGroup, this.childrenKey());
        association.bindAspect("isLeaf", displayGroup, this.isLeafKey());
        association.bindAspect("root", displayGroup, this.rootKey());
        association.bindAspect("value", displayGroup, this.valueKey());
        association.bindAspect("icon", displayGroup, this.iconKey());
        association.bindAspect("expandedIcon", displayGroup, this.expandedIconKey());
        association.bindAspect("enabled", enabledDisplayGroup, enabledKey);
        return association;
    }

    public void valueChanged(TreeSelectionEvent event) {
        NSMutableArray addedObjects = new NSMutableArray();
        NSMutableArray removedObjects = new NSMutableArray();
        TreePath[] paths = event.getPaths();
        int c = paths.length;
        for (int i = 0; i < c; ++i) {
            Object object = _SelectionUtilities.objectWithPath(paths[i]);
            if (event.isAddedPath(i)) {
                addedObjects.addObject(object);
                continue;
            }
            removedObjects.addObject(object);
        }
        this.selectionDidChange((NSArray)addedObjects, (NSArray)removedObjects);
        EOSwingUtilities.eventEnded();
    }

    public static class _SelectionUtilities
    extends JTree {
        public static JTree treeView(JScrollPane scrollPane) {
            return (JTree)scrollPane.getViewport().getView();
        }

        public static boolean isEmpty(TreeSelectionModel treeSelectionModel) {
            return treeSelectionModel == null || treeSelectionModel instanceof JTree.EmptySelectionModel;
        }

        public static Object objectWithPath(TreePath path) {
            return path == null ? null : _SelectionUtilities.userObject(path.getLastPathComponent());
        }

        public static NSArray objectsWithPaths(TreePath[] paths) {
            int pathsCount = paths == null ? 0 : paths.length;
            NSMutableArray objects = new NSMutableArray(pathsCount);
            for (int i = 0; i < pathsCount; ++i) {
                objects.addObject(_SelectionUtilities.objectWithPath(paths[i]));
            }
            return objects;
        }

        public static NSArray objectPathForPath(TreePath path) {
            int pathLength = path == null ? 0 : path.getPathCount();
            NSMutableArray objectPath = new NSMutableArray(pathLength);
            for (int i = 0; i < pathLength; ++i) {
                objectPath.addObject(_SelectionUtilities.userObject(path.getPathComponent(i)));
            }
            return objectPath;
        }

        public static NSArray objectPathsForPaths(TreePath[] paths) {
            int pathsCount = paths == null ? 0 : paths.length;
            NSMutableArray objectPaths = new NSMutableArray(pathsCount);
            for (int i = 0; i < pathsCount; ++i) {
                objectPaths.addObject((Object)_SelectionUtilities.objectPathForPath(paths[i]));
            }
            return objectPaths;
        }

        protected static Object userObject(Object lastComponent) {
            if (lastComponent instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)lastComponent).getUserObject();
                if (userObject instanceof EOSwingTreePlugin._TreeNode) {
                    return ((EOSwingTreePlugin._TreeNode)userObject).object();
                }
                return userObject;
            }
            return lastComponent;
        }

        public static TreePath pathForNumericPath(JTree tree, NSArray numericPath) {
            if (tree == null || _SelectionUtilities.isEmpty(numericPath)) {
                return null;
            }
            TreeModel model = tree.getModel();
            TreePath path = new TreePath(model.getRoot());
            int c = numericPath.count();
            for (int i = 1; i < c; ++i) {
                path = path.pathByAddingChild(model.getChild(path.getLastPathComponent(), ((Number)numericPath.objectAtIndex(i)).intValue()));
            }
            return path;
        }

        public static TreePath[] pathsForNumericPaths(JTree tree, NSArray numericPaths) {
            Object[] paths = _SelectionUtilities.emptyPaths(tree, numericPaths);
            int c = _SelectionUtilities.length(paths);
            for (int i = 0; i < c; ++i) {
                paths[i] = _SelectionUtilities.pathForNumericPath(tree, (NSArray)numericPaths.objectAtIndex(i));
            }
            return paths;
        }

        public static TreePath pathForObjectPath(JTree tree, NSArray objectPath) {
            if (tree == null || _SelectionUtilities.isEmpty(objectPath)) {
                return null;
            }
            TreeModel model = tree.getModel();
            TreePath path = new TreePath(model.getRoot());
            int c = objectPath.count();
            block0: for (int i = 1; i < c; ++i) {
                Object lastComponent = path.getLastPathComponent();
                int d = model.getChildCount(lastComponent);
                for (int j = 0; j < d; ++j) {
                    Object child = model.getChild(lastComponent, j);
                    if (_SelectionUtilities.userObject(child) != objectPath.objectAtIndex(i)) continue;
                    path = path.pathByAddingChild(child);
                    continue block0;
                }
            }
            return path;
        }

        public static TreePath[] pathsForObjectPaths(JTree tree, NSArray objectPaths) {
            Object[] paths = _SelectionUtilities.emptyPaths(tree, objectPaths);
            int c = _SelectionUtilities.length(paths);
            for (int i = 0; i < c; ++i) {
                paths[i] = _SelectionUtilities.pathForObjectPath(tree, (NSArray)objectPaths.objectAtIndex(i));
            }
            return paths;
        }

        public static TreePath pathForObject(JTree tree, Object object) {
            if (tree == null) {
                return null;
            }
            TreeModel model = tree.getModel();
            NSMutableSet previous = new NSMutableSet();
            NSMutableArray candidates = new NSMutableArray((Object)new TreePath(model.getRoot()));
            while (candidates.count() > 0) {
                TreePath path = (TreePath)candidates.objectAtIndex(0);
                if (!previous.containsObject((Object)path)) {
                    if (_SelectionUtilities.objectWithPath(path) == object) {
                        return path;
                    }
                    previous.addObject((Object)path);
                    Object lastComponent = path.getLastPathComponent();
                    int c = model.getChildCount(lastComponent);
                    for (int i = 0; i < c; ++i) {
                        candidates.addObject((Object)path.pathByAddingChild(model.getChild(lastComponent, i)));
                    }
                }
                candidates.removeObjectAtIndex(0);
            }
            return null;
        }

        public static TreePath[] pathsForObjects(JTree tree, NSArray objects) {
            Object[] paths = _SelectionUtilities.emptyPaths(tree, objects);
            int c = _SelectionUtilities.length(paths);
            for (int i = 0; i < c; ++i) {
                paths[i] = _SelectionUtilities.pathForObject(tree, objects.objectAtIndex(i));
            }
            return paths;
        }

        public static TreePath pathForObjectWithParentKey(JTree tree, Object object, String parentKey) {
            if (tree == null) {
                return null;
            }
            Object root = _SelectionUtilities.userObject(tree.getModel().getRoot());
            NSMutableSet previous = new NSMutableSet();
            NSMutableArray componentsReversed = new NSMutableArray();
            Object component = object;
            while (component != null) {
                if (previous.containsObject(component)) {
                    return null;
                }
                previous.addObject(component);
                componentsReversed.addObject(component);
                if (component == root) {
                    return _SelectionUtilities.pathForObjectPath(tree, _SelectionUtilities.reverse((NSArray)componentsReversed));
                }
                component = NSKeyValueCoding.Utility.valueForKey((Object)component, (String)parentKey);
            }
            return null;
        }

        public static TreePath[] pathsForObjectsWithParentKey(JTree tree, NSArray objects, String parentKey) {
            Object[] paths = _SelectionUtilities.emptyPaths(tree, objects);
            int c = _SelectionUtilities.length(paths);
            for (int i = 0; i < c; ++i) {
                paths[i] = _SelectionUtilities.pathForObjectWithParentKey(tree, objects.objectAtIndex(i), parentKey);
            }
            return paths;
        }

        protected static int length(Object[] objects) {
            return objects == null ? 0 : objects.length;
        }

        protected static boolean isEmpty(NSArray a) {
            return a == null || a.count() == 0;
        }

        protected static TreePath[] emptyPaths(JTree tree, NSArray objects) {
            return tree == null || _SelectionUtilities.isEmpty(objects) ? null : new TreePath[objects.count()];
        }

        protected static NSArray reverse(NSArray a) {
            if (_SelectionUtilities.isEmpty(a)) {
                return a;
            }
            NSMutableArray r = new NSMutableArray(a.count());
            Enumeration en = a.reverseObjectEnumerator();
            while (en.hasMoreElements()) {
                r.addObject(en.nextElement());
            }
            return r;
        }
    }
}

