/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOXMLUnarchiver;
import com.webobjects.eoapplication._EOValueConversion;
import com.webobjects.eoapplication._EOWidgetUtilities;
import com.webobjects.eointerface.swing.EOTable;
import com.webobjects.eointerface.swing.EOTextField;
import com.webobjects.eointerface.swing.EOView;
import com.webobjects.eointerface.swing.EOViewLayout;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

public abstract class EOWidgetController
extends EOComponentController {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOWidgetController");
    private JComponent _widget = null;
    private JComponent _labelComponent = null;
    private int _labelComponentPosition = 0;
    private int _widgetAlignment = 2;
    private int _labelComponentAlignment = 4;
    private boolean _usesLabelComponent = false;
    private boolean _highlightsLabel = false;
    private int _labelComponentWidth = 0;
    private Dimension _minimumWidgetSize = null;

    public EOWidgetController() {
        this.setUsesLabelComponent(this.preferredUsesLabelComponent());
        this.setLabelComponentPosition(this.preferredLabelComponentPosition());
    }

    public EOWidgetController(EOXMLUnarchiver unarchiver) {
        super(unarchiver);
        this.setWidgetAlignment(unarchiver.decodeAlignmentForKey("alignment", 2));
        this.setLabelComponentAlignment(unarchiver.decodeAlignmentForKey("labelAlignment", 4));
        this.setHighlightsLabel(unarchiver.decodeBooleanForKey("highlight", false));
        this.setLabelComponentPosition(unarchiver.decodePositionForKey("labelComponentPosition", this.preferredLabelComponentPosition()));
        this.setUsesLabelComponent(unarchiver.decodeBooleanForKey("usesLabelComponent", this.preferredUsesLabelComponent()));
        this.setLabelComponentWidth(unarchiver._decodeIntForKey("labelComponentWidth", 0, 0));
        int width = unarchiver._decodeIntForKey("minimumWidgetWidth", 0, 0);
        int height = unarchiver._decodeIntForKey("minimumWidgetHeight", 0, 0);
        if (width > 0 || height > 0) {
            this.setMinimumWidgetSize(new Dimension(width, height));
        }
    }

    public NSMutableDictionary _xmlParameters() {
        NSMutableDictionary parameters = super._xmlParameters();
        if (this._widgetAlignment != 2) {
            parameters.setObjectForKey((Object)_EOValueConversion.stringForAlignment((int)this._widgetAlignment), (Object)"alignment");
        }
        if (this._labelComponentAlignment != 4) {
            parameters.setObjectForKey((Object)_EOValueConversion.stringForAlignment((int)this._labelComponentAlignment), (Object)"labelAlignment");
        }
        if (this._highlightsLabel) {
            parameters.setObjectForKey((Object)(this._highlightsLabel ? Boolean.TRUE : Boolean.FALSE), (Object)"highlight");
        }
        if (this._labelComponentPosition != 0) {
            parameters.setObjectForKey((Object)_EOValueConversion.stringForPosition((int)this._labelComponentPosition), (Object)"labelComponentPosition");
        }
        if (this._usesLabelComponent != this.preferredUsesLabelComponent()) {
            parameters.setObjectForKey((Object)(this._usesLabelComponent ? Boolean.TRUE : Boolean.FALSE), (Object)"usesLabelComponent");
        }
        if (this._labelComponentWidth > 0) {
            parameters.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)this._labelComponentWidth), (Object)"labelComponentWidth");
        }
        if (this._minimumWidgetSize != null) {
            if (this._minimumWidgetSize.width > 0) {
                parameters.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)this._minimumWidgetSize.width), (Object)"minimumWidgetWidth");
            }
            if (this._minimumWidgetSize.height > 0) {
                parameters.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)this._minimumWidgetSize.height), (Object)"minimumWidgetHeight");
            }
        }
        return parameters;
    }

    public void dispose() {
        super.dispose();
        this.setWidget(null);
    }

    protected DefaultAction _defaultActionTarget() {
        return (DefaultAction)this._hierarchicalControllerForKey(DefaultAction._CLASS, "displayGroup", true);
    }

    protected JComponent toolTipComponent() {
        return this.widget();
    }

    protected int preferredLabelComponentPosition() {
        return 0;
    }

    protected boolean preferredUsesLabelComponent() {
        return false;
    }

    protected JComponent newLabelComponent(String label, int minimumWidth, boolean appendColon, int alignment, boolean highlightLabel) {
        String string = "";
        if (label != null && label.length() > 0) {
            string = appendColon ? label + EOUserInterfaceParameters._localizedColon() : label;
        }
        EOTextField labelComponent = _EOWidgetUtilities.newLabelComponent((String)string, (int)alignment, (boolean)highlightLabel);
        Dimension labelComponentSize = labelComponent.getSize();
        if (labelComponentSize.width < minimumWidth) {
            labelComponentSize.width = minimumWidth;
            labelComponent.setSize(labelComponentSize.width, labelComponentSize.height);
        }
        return labelComponent;
    }

    protected int preferredWidgetAutosizingMask() {
        return 0x10 | (!this.preferredUsesLabelComponent() || this.preferredLabelComponentPosition() != 0 ? 32 : 4);
    }

    protected int _labelComponentVerticalOffset() {
        return 0;
    }

    protected void _addLabelComponentToComponent(JComponent labelComponent, JComponent component, int x, int widgetHeight, boolean isSeparator) {
        if (labelComponent != null && component != null) {
            int autosizingMask;
            int y;
            component.add(labelComponent);
            int position = this.labelComponentPosition();
            switch (position) {
                case 1: 
                case 5: 
                case 6: {
                    y = this._labelComponentVerticalOffset();
                    autosizingMask = 4;
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    y = widgetHeight - labelComponent.getSize().height - this._labelComponentVerticalOffset();
                    autosizingMask = 8;
                    break;
                }
                default: {
                    y = (widgetHeight - labelComponent.getSize().height + 1) / 2;
                    autosizingMask = 12;
                }
            }
            if ((this.preferredWidgetAutosizingMask() & 0x20) == 0) {
                autosizingMask = 4;
            }
            autosizingMask = autosizingMask | 1 | (isSeparator ? 2 : 0);
            labelComponent.setLocation(x, y);
            EOViewLayout._setAutosizingMaskAndLastKnownSize((Component)labelComponent, (int)((this.canResizeHorizontally() ? autosizingMask & 0x13 : 0) | (this.canResizeVertically() ? autosizingMask & 0x2C : 0)));
        }
    }

    protected String _labelComponentString() {
        return this.label();
    }

    protected void generateComponent() {
        JComponent widget = this.newWidget();
        if (widget != null) {
            EOView component;
            EOViewLayout._setLastKnownSize((Component)widget);
            Dimension widgetSize = widget.getSize();
            Dimension minimumWidgetSize = this.minimumWidgetSize();
            if (minimumWidgetSize != null && (minimumWidgetSize.width > 0 || minimumWidgetSize.height > 0)) {
                if (minimumWidgetSize.width > 0) {
                    widgetSize.width = minimumWidgetSize.width;
                }
                if (minimumWidgetSize.height > 0) {
                    widgetSize.height = minimumWidgetSize.height;
                }
                widget.setSize(widgetSize);
            }
            JComponent labelComponent = null;
            if (this.usesLabelComponent()) {
                int labelComponentWidth = this.labelComponentWidth();
                labelComponent = this.newLabelComponent(this._labelComponentString(), labelComponentWidth, true, this.labelComponentAlignment(), this.highlightsLabel());
                Dimension labelComponentSize = labelComponent.getSize();
                if (!(widgetSize = EODisplayUtilities._unionSizeNoNewDimensionNeeded((Dimension)widgetSize, (int)(this._defaultComponentWidth(0) - labelComponentSize.width - EOUserInterfaceParameters._labelDistance), (int)this._defaultComponentHeight(0))).equals(widget.getSize())) {
                    widget.setSize(widgetSize.width, widgetSize.height);
                }
                widgetSize = EODisplayUtilities._unionSizeNoNewDimensionNeeded((Dimension)widgetSize, (int)widgetSize.width, (int)labelComponentSize.height);
                component = _EOWidgetUtilities.newView((int)(labelComponentSize.width + EOUserInterfaceParameters._labelDistance + widgetSize.width), (int)widgetSize.height);
                this._addLabelComponentToComponent(labelComponent, (JComponent)component, 0, widgetSize.height, false);
                component.add(widget);
                widget.setLocation(labelComponentSize.width + EOUserInterfaceParameters._labelDistance, 0);
                if (labelComponentWidth <= 0) {
                    labelComponent.putClientProperty("ComponentAlignmentLabelMarker", Boolean.TRUE);
                    widget.putClientProperty("ComponentAlignmentMinimumWidth", _NSUtilities.IntegerForInt((int)(minimumWidgetSize != null && minimumWidgetSize.width > 0 ? minimumWidgetSize.width : widgetSize.width)));
                    component.putClientProperty("ComponentAlignmentContainerMarker", Boolean.TRUE);
                    component.putClientProperty("ComponentAlignmentMinimumWidth", _NSUtilities.IntegerForInt((int)component.getWidth()));
                }
            } else {
                if (!(widgetSize = EODisplayUtilities._unionSizeNoNewDimensionNeeded((Dimension)widgetSize, (Dimension)this._defaultComponentSize(0, 0))).equals(widget.getSize())) {
                    widget.setSize(widgetSize.width, widgetSize.height);
                }
                component = _EOWidgetUtilities.newView((int)widgetSize.width, (int)widgetSize.height);
                component.add(widget);
                widget.setLocation(0, 0);
            }
            EOViewLayout._setLastKnownSize((Component)component);
            int autosizingMask = this.preferredWidgetAutosizingMask();
            EOViewLayout._setAutosizingMask((Component)widget, (int)((this.canResizeHorizontally() ? autosizingMask & 0x13 : 0) | (this.canResizeVertically() ? autosizingMask & 0x2C : 0)));
            this.setLabelComponent(labelComponent);
            this.setWidget(widget);
            this.setComponent((Component)component);
            this.setFirstFocusComponent(widget);
            this.setLastFocusComponent(widget);
        }
    }

    public void setLabelComponentPosition(int position) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("labelComponentPosition");
        }
        this._labelComponentPosition = position;
    }

    public int labelComponentPosition() {
        return this._labelComponentPosition;
    }

    public void setWidgetAlignment(int alignment) {
        this._widgetAlignment = alignment;
        if (this.isComponentPrepared()) {
            this.setAlignmentForWidget(this.widget(), alignment);
        }
    }

    public int widgetAlignment() {
        return this._widgetAlignment;
    }

    public void setLabelComponentAlignment(int alignment) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("labelComponentAlignment");
        }
        this._labelComponentAlignment = alignment;
    }

    public int labelComponentAlignment() {
        return this._labelComponentAlignment;
    }

    public void setUsesLabelComponent(boolean flag) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("usesLabelComponent");
        }
        this._usesLabelComponent = flag;
    }

    public boolean usesLabelComponent() {
        return this._usesLabelComponent;
    }

    public void setHighlightsLabel(boolean flag) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("highlightsLabel");
        }
        this._highlightsLabel = flag;
    }

    public boolean highlightsLabel() {
        return this._highlightsLabel;
    }

    public void setLabelComponentWidth(int labelComponentWidth) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("labelComponentWidth");
        }
        this._labelComponentWidth = labelComponentWidth > 0 ? labelComponentWidth : 0;
    }

    public int labelComponentWidth() {
        return this._labelComponentWidth;
    }

    public void setMinimumWidgetSize(Dimension size) {
        if (this.isComponentPrepared()) {
            this._raiseBecauseOfIllegalPropertyChangeAfterComponentPreparation("minimumWidgetSize");
        }
        this._minimumWidgetSize = size;
    }

    public Dimension minimumWidgetSize() {
        return this._minimumWidgetSize != null ? this._minimumWidgetSize : EODisplayUtilities._nullSize;
    }

    protected abstract JComponent newWidget();

    protected void setAlignmentForWidget(JComponent widget, int alignment) {
    }

    protected void startListeningToWidget() {
    }

    protected void stopListeningToWidget() {
    }

    public void setWidget(JComponent widget) {
        if (this._widget != widget) {
            if (this._widget != null) {
                this.stopListeningToWidget();
            }
            this._widget = widget;
            if (this._widget != null) {
                this.startListeningToWidget();
            }
        }
    }

    public JComponent widget() {
        if (this._widget == null) {
            this.prepareComponent();
        }
        return this._widget;
    }

    public void setLabelComponent(JComponent labelComponent) {
        this._labelComponent = labelComponent;
    }

    public JComponent labelComponent() {
        if (this._labelComponent == null) {
            this.prepareComponent();
        }
        return this._labelComponent;
    }

    public static interface DefaultAction {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOWidgetController$DefaultAction");

        public void defaultAction();

        public static interface CommonWidgetHandler {
            public boolean canTakeResposibilityForDefaultActionWithActionWidget(JComponent var1);

            public void takeResposibilityForDefaultActionWithActionWidget(JComponent var1);
        }
    }

    public static interface TableWidget {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOWidgetController$TableWidget");

        public EOTable table();

        public void setAllowsMultipleSelection(boolean var1);

        public boolean allowsMultipleSelection();
    }

    public static interface QueryWidget {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOWidgetController$QueryWidget");

        public void setIsQueryWidget(boolean var1);

        public boolean isQueryWidget();
    }

    public static interface FormatWidget {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOWidgetController$FormatWidget");

        public void setFormatAllowed(boolean var1);

        public boolean isFormatAllowed();

        public void setFormatClass(Class var1);

        public Class formatClass();

        public void setFormatPattern(String var1);

        public String formatPattern();
    }
}

