/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOResourceBundle;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class _EODictionaryXMLParser
extends DefaultHandler {
    private static String _BundleResourcePathImport = "importBundleResource";
    private static String _ArrayTag = "ARRAY";
    private static String _DictionaryTag = "DICTIONARY";
    private static String _StringTag = "STRING";
    private static SAXParserFactory _Factory;
    private static Object StateArray;
    private static Object StateDictionary;
    private static Object StateController;
    private static Object StateString;
    private NSBundle _bundle = null;
    private NSMutableArray _stack = new NSMutableArray(64);
    private NSMutableArray _document = new NSMutableArray();
    private NSMutableArray _state = new NSMutableArray(64);

    private static Object _parseXML(InputSource inputSource, NSBundle bundle) {
        _EODictionaryXMLParser dictionaryParser = new _EODictionaryXMLParser(bundle);
        dictionaryParser._parseDocument(inputSource);
        NSArray document = dictionaryParser.document();
        if (document != null) {
            int count = document.count();
            if (count == 1) {
                return document.objectAtIndex(0);
            }
            if (count > 0) {
                throw new IllegalStateException("XML document must have a single root object, multiple objects are not allowed");
            }
        }
        return null;
    }

    public static Object parseXML(String xmlString) {
        return xmlString != null && xmlString.length() > 0 ? _EODictionaryXMLParser._parseXML(new InputSource(new StringReader(xmlString)), null) : null;
    }

    public static Object parseXML(NSData xmlData) {
        int length;
        if (xmlData != null && (length = xmlData.length()) > 0) {
            return _EODictionaryXMLParser._parseXML(new InputSource(new ByteArrayInputStream(xmlData.bytes(), 0, length)), null);
        }
        return null;
    }

    public static Object parseXML(NSBundle bundle, String resourcePath) throws IOException {
        String string = EOResourceBundle._stringFromBundleResource((NSBundle)bundle, (String)resourcePath);
        if (string != null) {
            try {
                return _EODictionaryXMLParser._parseXML(new InputSource(new StringReader(string)), bundle);
            }
            catch (NSForwardException exception) {
                Throwable throwable = exception.originalException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw exception;
            }
        }
        return null;
    }

    public _EODictionaryXMLParser(NSBundle bundle) {
        this._bundle = bundle;
        this._stack.addObject((Object)this._document);
        this._state.addObject(StateArray);
    }

    private XMLReader _initReader() {
        try {
            return _Factory.newSAXParser().getXMLReader();
        }
        catch (SAXException exception) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        catch (ParserConfigurationException exception) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
    }

    private void _parseDocument(InputSource inputSource) {
        XMLReader reader = this._initReader();
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        try {
            reader.parse(inputSource);
        }
        catch (SAXException exception) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x200000L)) {
                NSLog.debug.appendln((Object)("XML parse error: " + exception.getMessage()));
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        catch (IOException exception) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
    }

    public NSArray document() {
        return this._document;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String explicitName = attributes.getValue("name");
        if (explicitName == null) {
            explicitName = name;
        }
        if (name.equals(_ArrayTag)) {
            NSMutableArray array = new NSMutableArray();
            if (this._state.lastObject() == StateArray) {
                ((NSMutableArray)this._stack.lastObject()).addObject((Object)array);
            } else {
                ((NSMutableDictionary)this._stack.lastObject()).setObjectForKey((Object)array, (Object)explicitName);
            }
            this._stack.addObject((Object)array);
            this._state.addObject(StateArray);
        } else if (name.equals(_DictionaryTag)) {
            NSMutableDictionary dictionary = new NSMutableDictionary();
            if (this._state.lastObject() == StateArray) {
                ((NSMutableArray)this._stack.lastObject()).addObject((Object)dictionary);
            } else {
                ((NSMutableDictionary)this._stack.lastObject()).setObjectForKey((Object)dictionary, (Object)explicitName);
            }
            this._stack.addObject((Object)dictionary);
            this._state.addObject(StateDictionary);
        } else if (name.equals(_StringTag)) {
            String string = attributes.getValue("value");
            if (string == null) {
                string = "";
            }
            if (this._state.lastObject() == StateArray) {
                ((NSMutableArray)this._stack.lastObject()).addObject((Object)string);
            } else {
                ((NSMutableDictionary)this._stack.lastObject()).setObjectForKey((Object)string, (Object)explicitName);
            }
            this._state.addObject(StateString);
        } else {
            NSMutableDictionary element = new NSMutableDictionary(8);
            if (this._state.lastObject() == StateArray) {
                ((NSMutableArray)this._stack.lastObject()).addObject((Object)element);
            } else if (this._state.lastObject() == StateDictionary) {
                ((NSMutableDictionary)this._stack.lastObject()).setObjectForKey((Object)element, (Object)explicitName);
            } else {
                ((NSMutableArray)((NSMutableDictionary)this._stack.lastObject()).objectForKey((Object)"_eochildren")).addObject((Object)element);
            }
            int c = attributes.getLength();
            for (int i = 0; i < c; ++i) {
                String attName = attributes.getQName(i);
                String value = attributes.getValue(i);
                element.setObjectForKey((Object)value, (Object)attName);
            }
            element.setObjectForKey((Object)new NSMutableArray(), (Object)"_eochildren");
            element.setObjectForKey((Object)name, (Object)"_eotag");
            this._stack.addObject((Object)element);
            this._state.addObject(StateController);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        Object state = this._state.lastObject();
        this._state.removeLastObject();
        if (state != StateString) {
            this._stack.removeLastObject();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target != null && target.equals(_BundleResourcePathImport)) {
            if (this._bundle == null) {
                throw new IllegalStateException("Processing instruction " + target + " for " + data + " cannot be processed without bundle information");
            }
            try {
                String string = EOResourceBundle._stringFromBundleResource((NSBundle)this._bundle, (String)data);
                if (string != null) {
                    this._parseDocument(new InputSource(new StringReader(string)));
                } else if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x200000L)) {
                    NSLog.debug.appendln((Object)("XML processing instruction error: Can't find resource path " + data + " in bundle " + this._bundle));
                }
            }
            catch (IOException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    static {
        StateArray = new Object();
        StateDictionary = new Object();
        StateController = new Object();
        StateString = new Object();
        _Factory = SAXParserFactory.newInstance();
    }
}

