/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eoapplication.EOResourceBundle;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.eogeneration._EODictionaryXMLParser;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import java.io.IOException;

public class _EOFileXMLProvider
extends EOControllerFactory._XMLProvider {
    private NSDictionary _bundlesToXMLPathsMapTable;
    private NSDictionary _filenameMapTable = null;

    private NSDictionary _bundlesToXMLPathsMapTable() {
        if (this._bundlesToXMLPathsMapTable == null) {
            this._bundlesToXMLPathsMapTable = EOResourceBundle._resourceBundlesToResourcePathsMapTable((String[])new String[]{"xml"});
        }
        return this._bundlesToXMLPathsMapTable;
    }

    private Object _lookupXMLFile(NSDictionary specification, String filename, String locale, String platform) {
        NSDictionary bundlesMapTable = this._bundlesToXMLPathsMapTable();
        NSArray resourceBundles = EOResourceBundle._resourceBundles();
        int count = resourceBundles.count();
        for (int i = 0; i < count; ++i) {
            String resourcePath;
            NSBundle bundle = (NSBundle)resourceBundles.objectAtIndex(i);
            NSArray resourcePaths = (NSArray)bundlesMapTable.objectForKey((Object)bundle);
            if (!resourcePaths.containsObject((Object)(resourcePath = (locale != null ? locale + ".lproj/" : EOResourceBundle._NonLocalizedResourcePath) + filename + (platform != null ? "-" + platform : "") + ".xml"))) continue;
            try {
                Object object = _EODictionaryXMLParser.parseXML(bundle, resourcePath);
                if (object != null && specification != null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)8L)) {
                    NSLog.debug.appendln((Object)("Loading XML for specification " + specification + " from resource path " + resourcePath + " of bundle with name " + bundle.name()));
                }
                return object;
            }
            catch (IOException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        return null;
    }

    private NSDictionary _filenameMapTable() {
        if (this._filenameMapTable == null) {
            NSDictionary info = (NSDictionary)this._lookupXMLFile(null, "filenames", null, null);
            this._filenameMapTable = info != null ? new NSDictionary(info.allKeys(), info.allValues()) : NSDictionary.EmptyDictionary;
        }
        return this._filenameMapTable;
    }

    public Object _provideXML(NSDictionary specification) {
        if (specification != null) {
            EOApplication application = EOApplication.sharedApplication();
            NSMutableDictionary simplifiedSpecification = new NSMutableDictionary(specification);
            NSArray locales = (NSArray)simplifiedSpecification.objectForKey((Object)"locales");
            if (locales != null) {
                simplifiedSpecification.removeObjectForKey((Object)"locales");
            } else {
                locales = application.localeIndicators();
            }
            NSArray platformIndicators = (NSArray)simplifiedSpecification.objectForKey((Object)"platforms");
            if (platformIndicators != null) {
                simplifiedSpecification.removeObjectForKey((Object)"platforms");
            } else {
                platformIndicators = application.platformIndicators();
            }
            String filename = (String)this._filenameMapTable().objectForKey((Object)simplifiedSpecification);
            if (filename == null) {
                String question = (String)simplifiedSpecification.objectForKey((Object)"question");
                if (question != null) {
                    simplifiedSpecification.removeObjectForKey((Object)"question");
                    filename = (question != null ? question : "") + (simplifiedSpecification.count() > 0 ? "_" + EOControllerFactory.sharedControllerFactory()._uniqueDescriptionForSpecification((NSDictionary)simplifiedSpecification) : "");
                } else {
                    filename = EOControllerFactory.sharedControllerFactory()._uniqueDescriptionForSpecification((NSDictionary)simplifiedSpecification);
                }
            }
            int numberOfLocales = locales.count();
            int numberOfPlatformIndicators = platformIndicators.count();
            for (int localeIndex = 0; localeIndex <= numberOfLocales; ++localeIndex) {
                String locale = null;
                if (localeIndex != numberOfLocales) {
                    locale = (String)locales.objectAtIndex(localeIndex);
                }
                for (int platformIndicatorIndex = 0; platformIndicatorIndex <= numberOfPlatformIndicators; ++platformIndicatorIndex) {
                    Object xml;
                    String platform = null;
                    if (platformIndicatorIndex != numberOfPlatformIndicators) {
                        platform = (String)platformIndicators.objectAtIndex(platformIndicatorIndex);
                    }
                    if ((xml = this._lookupXMLFile(specification, filename, locale, platform)) == null) continue;
                    return xml;
                }
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8L)) {
                NSLog.debug.appendln((Object)("Can't identify XML file for specification " + specification));
            }
        }
        return null;
    }
}

