/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOActionButtonsController;
import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODefaults;
import com.webobjects.eoapplication.EODialogController;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eoapplication.EOObjectDisplay;
import com.webobjects.eoapplication.EOSimpleWindowController;
import com.webobjects.eoapplication.EOSwitchController;
import com.webobjects.eoapplication.EOTabSwitchController;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOWindowObserver;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.eogeneration.assistant.EOAssistantRule;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.awt.Window;

public class EOAssistant
extends EOComponentController
implements EOApplication._QuitHandler {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOAssistant");
    public static final String MainEntityNamesKey = "mainEntityNames";
    public static final String EnumerationEntityNamesKey = "enumerationEntityNames";
    public static final String KeysKey = "keys";
    public static final String PropertyKeyKey = "propertyKey";
    public static final String ControllerTypeKey = "controllerType";
    public static final String WidgetControllerKey = "widgetController";
    public static final String IsRootControllerKey = "isRootController";
    private static final NSSelector _activeWindowDidChangeSelector = new NSSelector("activeWindowDidChange", _NSUtilities._NotificationClassArray);
    static final String _AllIdentifier = "<ALL>";
    static final String _DefaultIdentifier = "<DEFAULT>";
    static final int _DefaultTableWidth = 160;
    static final int _DefaultTableHeight = 240;
    private static EOSimpleWindowController _sharedInstanceRootController = null;
    private static EOAssistant _sharedInstance = null;
    private static _RuleProvider _ruleProvider = null;
    private static EOAction _standardApplyActionForControllerHierarchy = null;
    private static EOAction _standardRestartActionForControllerHierarchy = null;
    private static final Object _noValuePlaceholder = new NSArray();
    private EOSwitchController _switchController = null;
    private boolean _rulesLoaded = false;
    private NSMutableArray _rules = new NSMutableArray(256);
    private NSMutableDictionary _uniqueIdentifierRuleMapTable = new NSMutableDictionary(64);
    private NSMutableDictionary _keyRulesMapTable = new NSMutableDictionary(256);
    private NSMutableDictionary _defaultValuesMapTable = new NSMutableDictionary(256);
    private NSMutableDictionary _allValuesMapTable = new NSMutableDictionary(256);
    private NSArray _allEntityNames = null;
    private boolean _hasUnsavedChanges = false;
    private boolean _hasUnappliedChanges = false;
    private NSMutableDictionary _editorSpecificationValues = new NSMutableDictionary(8);

    public static void startAssistant(NSArray assistantEditorClassNames) {
        if (_sharedInstanceRootController == null) {
            _sharedInstanceRootController = new EODialogController();
            _sharedInstanceRootController.setWindowPosition(5);
            _sharedInstanceRootController.setUsesUserDefaultsWindowLocation(true);
            _sharedInstanceRootController.setUsesUserDefaultsWindowSize(true);
            EOActionButtonsController actionButtonsController = new EOActionButtonsController();
            actionButtonsController.setActionWidgetPosition(3);
            actionButtonsController.setUsesLargeButtonRepresentation(true);
            _sharedInstance = new EOAssistant();
            actionButtonsController.addSubcontroller((EOController)_sharedInstance);
            _sharedInstanceRootController.addSubcontroller((EOController)actionButtonsController);
            if (assistantEditorClassNames != null) {
                int i;
                int count = assistantEditorClassNames.count();
                NSMutableArray editors = new NSMutableArray(count);
                for (i = 0; i < count; ++i) {
                    Editor editor = (Editor)EOController._newController((String)((String)assistantEditorClassNames.objectAtIndex(i)));
                    if (editor == null) continue;
                    editors.addObject((Object)editor);
                }
                try {
                    editors.sortUsingComparator(new NSComparator(){

                        public int compare(Object object1, Object object2) throws NSComparator.ComparisonException {
                            if (object1 != object2) {
                                int priority2;
                                int priority1 = ((Editor)object1).priority();
                                if (priority1 < (priority2 = ((Editor)object2).priority())) {
                                    return -1;
                                }
                                if (priority1 > priority2) {
                                    return 1;
                                }
                            }
                            return 0;
                        }
                    });
                }
                catch (NSComparator.ComparisonException exception) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
                }
                count = editors.count();
                for (i = 0; i < count; ++i) {
                    _sharedInstance.addEditor((Editor)editors.objectAtIndex(i));
                }
            }
            _sharedInstance._revertAllRules();
            _sharedInstance.activeWindowDidChange(null);
        }
        _sharedInstanceRootController.makeVisible();
        EOControllerFactory.sharedControllerFactory().setCachesControllers(false);
    }

    public static EOAssistant sharedAssistant() {
        return _sharedInstance;
    }

    public static void _useRuleProviderIfNotSpecified(_RuleProvider ruleProvider) {
        if (_ruleProvider == null) {
            EOAssistant._setRuleProvider(ruleProvider);
        }
    }

    public static void _setRuleProvider(_RuleProvider ruleProvider) {
        _ruleProvider = ruleProvider;
    }

    public static _RuleProvider _ruleProvider() {
        if (_ruleProvider == null) {
            throw new IllegalStateException("Rule Provider not initialized - please initialize principal classes correctly");
        }
        return _ruleProvider;
    }

    private static EOAction _standardApplyActionForControllerHierarchy() {
        if (_standardApplyActionForControllerHierarchy == null) {
            _standardApplyActionForControllerHierarchy = EOAction._standardActionForControllerHierarchy((String)"apply", (String)EOUserInterfaceParameters.localizedString((String)"Document"), (String)"Apply", (boolean)false, (String)"Ok", null, (int)100, (int)290);
        }
        return _standardApplyActionForControllerHierarchy;
    }

    private static EOAction _standardRestartActionForControllerHierarchy() {
        if (_standardRestartActionForControllerHierarchy == null) {
            _standardRestartActionForControllerHierarchy = EOAction._standardActionForControllerHierarchy((String)"restart", (String)EOUserInterfaceParameters.localizedString((String)"Document"), (String)"Restart", (boolean)false, (String)"Clear", null, (int)310, (int)100);
        }
        return _standardRestartActionForControllerHierarchy;
    }

    private EOAssistant() {
        this._setDefaultComponentSize(512, 0);
        this.setTypeName("EOAssistant");
        this.setLabel("Assistant");
        this._switchController = new EOTabSwitchController();
        this.addSubcontroller((EOController)this._switchController);
        EOApplication.sharedApplication()._addQuitHandler((EOApplication._QuitHandler)this);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, _activeWindowDidChangeSelector, "EOActiveWindowChanged", null);
    }

    public void dispose() {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
        super.dispose();
    }

    protected void _updateUserInterface() {
        if (this.isVisible()) {
            this.activeWindowDidChange(null);
        }
        super._updateUserInterface();
    }

    protected boolean _needsUserInterfaceUpdateNotifications() {
        return this.isVisible() || super._needsUserInterfaceUpdateNotifications();
    }

    public void addEditor(Editor editor) {
        this._switchController.addSubcontroller((EOController)editor);
    }

    public NSArray editors() {
        return this._switchController.subcontrollers();
    }

    public void setEditorSpecificationValueForKey(String value, String key) {
        if (key != null) {
            if (value != null) {
                this._editorSpecificationValues.setObjectForKey((Object)value, (Object)key);
            } else {
                this._editorSpecificationValues.removeObjectForKey((Object)key);
            }
        }
    }

    public String editorSpecificationValueForKey(String key) {
        return key != null ? (String)this._editorSpecificationValues.objectForKey((Object)key) : null;
    }

    protected NSArray defaultActions() {
        NSMutableArray actions = new NSMutableArray(4);
        actions.addObject((Object)EOAssistant._standardApplyActionForControllerHierarchy());
        actions.addObject((Object)EOAction.standardSaveActionForControllerHierarchy());
        actions.addObject((Object)EOAction.standardRevertActionForControllerHierarchy());
        actions.addObject((Object)EOAssistant._standardRestartActionForControllerHierarchy());
        return actions;
    }

    public boolean canPerformActionNamed(String actionName) {
        if (actionName.equals("apply")) {
            return this._hasUnappliedChanges;
        }
        if (actionName.equals("save")) {
            return this._hasUnsavedChanges;
        }
        if (actionName.equals("revert")) {
            return this._hasUnappliedChanges || this._hasUnsavedChanges;
        }
        return actionName.equals("restart");
    }

    private void _invalidateAllCachesAndData() {
        EODefaults defaults = EOApplication.sharedApplication().defaults();
        if (defaults != null) {
            defaults.clearAllValues();
        }
        EOControllerFactory factory = EOControllerFactory.sharedControllerFactory();
        factory.invalidateRules();
        factory.setCachesControllers(false);
        EOUserInterfaceParameters._populateValuesWithDefaults((boolean)true, (boolean)true);
        EOAction._clearAllSharedActions();
    }

    private boolean _apply(boolean save) {
        NSArray enumerationEntityNames;
        NSArray mainEntityNames;
        if (!(this.allEntityNames().count() <= 0 || (mainEntityNames = (NSArray)this.ruleValue(MainEntityNamesKey, null)) != null && mainEntityNames.count() != 0 || (enumerationEntityNames = (NSArray)this.ruleValue(EnumerationEntityNamesKey, null)) != null && enumerationEntityNames.count() != 0 || EODialogs.runConfirmOperationDialog((String)"Warning", (String)"You have no main and no enumeration entities selected. Do you really want to use these changes?", (String)"Use Changes"))) {
            return false;
        }
        NSArray rules = this.rules();
        if (save && this._hasUnsavedChanges) {
            this._sendAllRules(rules, true);
            this._markSavedAndApplied();
        } else if (this._hasUnappliedChanges) {
            this._sendAllRules(rules, false);
            this._hasUnappliedChanges = false;
        }
        this._invalidateAllCachesAndData();
        return true;
    }

    public boolean apply() {
        return this._apply(false);
    }

    public boolean save() {
        return this._apply(true);
    }

    private void _revert() {
        this._rulesLoaded = false;
        this._rules.removeAllObjects();
        this._uniqueIdentifierRuleMapTable.removeAllObjects();
        this._keyRulesMapTable.removeAllObjects();
        this._markSavedAndApplied();
        this._revertAllRules();
        this._refresh();
        this._invalidateAllCachesAndData();
    }

    public void revert() {
        if (EODialogs.runConfirmOperationDialog((String)"Revert", (String)"Do you really want to revert to the saved version?", (String)"Revert")) {
            this._revert();
        }
    }

    public void restart() {
        block8: {
            block7: {
                if (!this._hasUnappliedChanges) break block7;
                int operation = EODialogs.runChooseOperationDialog((String)"Restart", (String)"Apply changes in assistant before restarting the application?", (String)"Apply", (String)"Don't Apply");
                switch (operation) {
                    case 0: {
                        if (!this.apply()) {
                            return;
                        }
                        break block8;
                    }
                    case 1: {
                        break block8;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (!EODialogs.runConfirmOperationDialog((String)"Restart", (String)"Do you really want to restart the application?", (String)"Restart")) {
                return;
            }
        }
        NSArray subcontrollers = EOApplication.sharedApplication().subcontrollers();
        int count = subcontrollers.count();
        for (int i = count - 1; i >= 0; --i) {
            EOController._disposeController((EOController)((EOController)subcontrollers.objectAtIndex(i)));
        }
        this._invalidateAllCachesAndData();
        EOControllerFactory.sharedControllerFactory().activateDefaultControllers();
    }

    public boolean _canApplicationQuit() {
        if (this._hasUnsavedChanges) {
            _sharedInstanceRootController.makeVisible();
            switch (EODialogs.runChooseOperationDialog((String)EOUserInterfaceParameters.localizedString((String)"Alert"), (String)EOUserInterfaceParameters.localizedString((String)"Save changes in Assistant?"), (String)EOUserInterfaceParameters.localizedString((String)"Save"), (String)EOUserInterfaceParameters.localizedString((String)"Don't Save"))) {
                case 0: {
                    return this.save();
                }
                case 1: {
                    this._revert();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void _refresh() {
        this.invokeMethod(1, Editor._CLASS, "refresh", null, null);
    }

    private void _ensureRulesLoaded() {
        if (!this._rulesLoaded) {
            this._rulesLoaded = true;
            this._requestAllRules();
        }
    }

    public NSArray rules() {
        this._ensureRulesLoaded();
        return this._rules;
    }

    private NSDictionary _uniqueIdentifierRuleMapTable() {
        this._ensureRulesLoaded();
        return this._uniqueIdentifierRuleMapTable;
    }

    private NSArray _ruleCandidates(String key, NSDictionary specification) {
        this._ensureRulesLoaded();
        return (NSArray)this._keyRulesMapTable.objectForKey((Object)key);
    }

    protected void addRule(EOAssistantRule rule) {
        if (rule != null && !this._rules.containsObject((Object)rule)) {
            String key = rule.key();
            this._rules.addObject((Object)rule);
            this._uniqueIdentifierRuleMapTable.setObjectForKey((Object)rule, (Object)this._uniqueIdentifierForKeyAndSpecification(key, rule.specification()));
            if (key != null) {
                NSMutableArray rules = (NSMutableArray)this._keyRulesMapTable.objectForKey((Object)key);
                if (rules == null) {
                    rules = new NSMutableArray();
                    this._keyRulesMapTable.setObjectForKey((Object)rules, (Object)key);
                }
                rules.addObject((Object)rule);
            }
        }
    }

    protected void removeRule(EOAssistantRule rule) {
        if (rule != null && this._rules.containsObject((Object)rule)) {
            NSMutableArray rules;
            String key = rule.key();
            this._rules.removeObject((Object)rule);
            this._uniqueIdentifierRuleMapTable.removeObjectForKey((Object)this._uniqueIdentifierForKeyAndSpecification(key, rule.specification()));
            if (key != null && (rules = (NSMutableArray)this._keyRulesMapTable.objectForKey((Object)key)) != null) {
                rules.removeObject((Object)rule);
            }
        }
    }

    public void _mergeStrings(NSMutableArray strings, NSArray mergeStrings) {
        if (strings != null && mergeStrings != null) {
            int count = mergeStrings.count();
            for (int i = 0; i < count; ++i) {
                String string = (String)mergeStrings.objectAtIndex(i);
                if (strings.indexOfObject((Object)string) >= 0) continue;
                strings.addObject((Object)string);
            }
        }
    }

    public void _filterOutStrings(NSMutableArray strings, NSArray filterOutStrings) {
        if (strings != null && filterOutStrings != null) {
            int count = filterOutStrings.count();
            for (int i = 0; i < count; ++i) {
                int index = strings.indexOfObject(filterOutStrings.objectAtIndex(i));
                if (index < 0) continue;
                strings.removeObjectAtIndex(index);
            }
        }
    }

    public String _uniqueIdentifierForKeyAndSpecification(String key, NSDictionary specification) {
        String string;
        StringBuffer buffer = new StringBuffer();
        if (key != null) {
            buffer.append(key);
        }
        buffer.append(": ");
        if (specification != null && (string = EOControllerFactory.sharedControllerFactory()._uniqueDescriptionForSpecification(specification)) != null) {
            buffer.append(string);
        }
        return buffer.toString();
    }

    public Object _defaultValue(String key, NSDictionary specification, String identifierForKeyAndSpecification) {
        Object value;
        if (identifierForKeyAndSpecification == null) {
            identifierForKeyAndSpecification = this._uniqueIdentifierForKeyAndSpecification(key, specification);
        }
        if ((value = this._defaultValuesMapTable.objectForKey((Object)identifierForKeyAndSpecification)) == null) {
            value = this._requestDefaultValue(key, specification);
            if (value == null) {
                value = _noValuePlaceholder;
            }
            this._defaultValuesMapTable.setObjectForKey(value, (Object)identifierForKeyAndSpecification);
        }
        return value != _noValuePlaceholder ? value : null;
    }

    public Object defaultValue(String key, NSDictionary specification) {
        return this._defaultValue(key, specification, null);
    }

    public boolean hasRuleValueOtherThanDefault(String key, NSDictionary specification) {
        return this._uniqueIdentifierRuleMapTable().objectForKey((Object)this._uniqueIdentifierForKeyAndSpecification(key, specification)) != null;
    }

    public Object _bestMatchingRuleValue(String key, NSDictionary specification, String uniqueKeyAndSpecificationIdentifier) {
        EOAssistantRule rule = null;
        if (specification != null) {
            int minimumNumberOfParameters = -1;
            NSArray rules = this._ruleCandidates(key, specification);
            if (rules != null) {
                int numberOfRules = rules.count();
                for (int i = 0; i < numberOfRules; ++i) {
                    EOAssistantRule testRule = (EOAssistantRule)rules.objectAtIndex(i);
                    NSDictionary testSpecification = testRule.specification();
                    if (testSpecification != null) {
                        int numberOfParameters = testSpecification.count();
                        if (numberOfParameters <= minimumNumberOfParameters) continue;
                        NSArray parameters = testSpecification.allKeys();
                        boolean identical = true;
                        for (int j = 0; j < numberOfParameters && identical; ++j) {
                            String testKey = (String)parameters.objectAtIndex(j);
                            Object value = specification.objectForKey((Object)testKey);
                            if (value != null && testSpecification.objectForKey((Object)testKey).equals(value)) continue;
                            identical = false;
                        }
                        if (!identical) continue;
                        rule = testRule;
                        minimumNumberOfParameters = numberOfParameters;
                        continue;
                    }
                    if (rule != null) continue;
                    rule = testRule;
                    minimumNumberOfParameters = 0;
                }
            }
        }
        return rule != null ? rule.value() : this._defaultValue(key, specification, uniqueKeyAndSpecificationIdentifier);
    }

    public Object ruleValue(String key, NSDictionary specification) {
        String string = this._uniqueIdentifierForKeyAndSpecification(key, specification);
        EOAssistantRule rule = (EOAssistantRule)this._uniqueIdentifierRuleMapTable().objectForKey((Object)string);
        return rule != null ? rule.value() : this._bestMatchingRuleValue(key, specification, string);
    }

    public Object ruleValue(String key, NSDictionary specification, NSDictionary alternateSpecification) {
        String string;
        NSDictionary uniqueIdentifierRuleMapTable = this._uniqueIdentifierRuleMapTable();
        EOAssistantRule rule = (EOAssistantRule)uniqueIdentifierRuleMapTable.objectForKey((Object)(string = this._uniqueIdentifierForKeyAndSpecification(key, specification)));
        if (rule == null && alternateSpecification != null) {
            rule = (EOAssistantRule)uniqueIdentifierRuleMapTable.objectForKey((Object)this._uniqueIdentifierForKeyAndSpecification(key, alternateSpecification));
        }
        return rule != null ? rule.value() : this._bestMatchingRuleValue(key, specification, string);
    }

    private void _markSavedAndApplied() {
        _sharedInstanceRootController.setLabel("Assistant");
        this._hasUnappliedChanges = false;
        this._hasUnsavedChanges = false;
    }

    private void _markEdited() {
        if (!this._hasUnsavedChanges) {
            _sharedInstanceRootController.setLabel("* Assistant");
        }
        this._hasUnappliedChanges = true;
        this._hasUnsavedChanges = true;
    }

    public void setRuleValue(String key, NSDictionary specification, Object value) {
        specification = specification != null ? new NSDictionary(specification) : null;
        EOAssistantRule rule = (EOAssistantRule)this._uniqueIdentifierRuleMapTable().objectForKey((Object)this._uniqueIdentifierForKeyAndSpecification(key, specification));
        if (rule != null) {
            rule.setValue(value);
        } else {
            rule = new EOAssistantRule(key, specification, value);
            this.addRule(rule);
        }
        this._markEdited();
    }

    public void resetRuleValueToDefault(String key, NSDictionary specification) {
        EOAssistantRule rule = (EOAssistantRule)this._uniqueIdentifierRuleMapTable().objectForKey((Object)this._uniqueIdentifierForKeyAndSpecification(key, specification));
        if (rule != null) {
            this.removeRule(rule);
            this._markEdited();
        }
    }

    public NSArray allQuestionNames() {
        return this.allValuesForKey("assistantQuestionName");
    }

    public NSArray allEntityNames() {
        if (this._allEntityNames == null) {
            this._allEntityNames = this._requestAllEntityNames();
        }
        return this._allEntityNames;
    }

    public NSArray allPropertyKeyTaskNames() {
        return this.allValuesForKey("assistantPropertyKeyTaskName");
    }

    public NSArray allPrimitivePropertyKeyTaskNames() {
        return this.allValuesForKey("assistantPrimitivePropertyKeyTaskName");
    }

    public NSArray _allQuestionTaskNames(String question, boolean entityTaskName) {
        return this.allValuesForKey("assistant" + _NSStringUtilities.capitalizedString((String)question) + (entityTaskName ? "Entity" : "") + "TaskName");
    }

    public NSArray allValuesForValueKey(String key) {
        return this.allValuesForKey("assistant" + _NSStringUtilities.capitalizedString((String)key) + "Value");
    }

    public NSArray allValuesForKey(String key) {
        if (key != null) {
            NSArray values = (NSArray)this._allValuesMapTable.objectForKey((Object)key);
            if (values == null) {
                values = this._requestAllPossibleValuesForKey(key);
                if (values == null) {
                    values = (NSArray)_noValuePlaceholder;
                }
                this._allValuesMapTable.setObjectForKey((Object)values, (Object)key);
            }
            return values != _noValuePlaceholder ? values : null;
        }
        return null;
    }

    private void _revertAllRules() {
        EOAssistant._ruleProvider().revertRules();
    }

    private void _sendAllRules(NSArray rules, boolean save) {
        NSMutableArray ruleDescriptions = new NSMutableArray();
        if (rules != null) {
            int count = rules.count();
            for (int i = 0; i < count; ++i) {
                Object value;
                String key;
                EOAssistantRule rule = (EOAssistantRule)rules.objectAtIndex(i);
                NSMutableDictionary description = new NSMutableDictionary(3);
                NSDictionary specification = rule.specification();
                if (specification != null) {
                    description.setObjectForKey((Object)specification, (Object)"specification");
                }
                if ((key = rule.key()) != null) {
                    description.setObjectForKey((Object)key, (Object)"key");
                }
                if ((value = rule.value()) != null) {
                    description.setObjectForKey(value, (Object)"value");
                }
                ruleDescriptions.addObject((Object)description);
            }
        }
        if (save) {
            EOAssistant._ruleProvider().saveRuleDescriptions((NSArray)ruleDescriptions);
        } else {
            EOAssistant._ruleProvider().applyRuleDescriptions((NSArray)ruleDescriptions);
        }
    }

    private void _requestAllRules() {
        NSArray ruleDescriptions = EOAssistant._ruleProvider().ruleDescriptions();
        if (ruleDescriptions != null) {
            int count = ruleDescriptions.count();
            for (int i = 0; i < count; ++i) {
                NSDictionary description = (NSDictionary)ruleDescriptions.objectAtIndex(i);
                this.addRule(new EOAssistantRule((String)description.objectForKey((Object)"key"), (NSDictionary)description.objectForKey((Object)"specification"), description.objectForKey((Object)"value")));
            }
        }
    }

    private Object _requestDefaultValue(String key, NSDictionary specification) {
        return EOAssistant._ruleProvider().defaultValue(key, specification);
    }

    private NSArray _requestAllEntityNames() {
        NSArray entityNames = EOAssistant._ruleProvider().allEntityNames();
        return entityNames != null ? entityNames : NSArray.EmptyArray;
    }

    private NSArray _requestAllPossibleValuesForKey(String key) {
        NSArray values = EOAssistant._ruleProvider().allPossibleValuesForKey(key);
        return values != null ? values : NSArray.EmptyArray;
    }

    private boolean _updateEditorSelectionValue(String value, String key) {
        String string;
        if (!(value == null || (string = this.editorSpecificationValueForKey(key)) != null && string.equals(value))) {
            this.setEditorSpecificationValueForKey(value, key);
            return true;
        }
        return false;
    }

    public void activeWindowDidChange(NSNotification notification) {
        NSDictionary specification;
        EOController controller;
        Window window;
        EOWindowObserver windowObserver;
        EOWindowObserver eOWindowObserver = windowObserver = notification != null ? (EOWindowObserver)notification.object() : EOApplication.sharedApplication().windowObserver();
        if (windowObserver != null && (window = windowObserver.activeWindow()) != _sharedInstanceRootController.window() && (controller = windowObserver.controllerForActiveWindow()) != null && (specification = (NSDictionary)controller._info("specification")) != null) {
            boolean refresh = this._updateEditorSelectionValue((String)specification.objectForKey((Object)"question"), "question");
            refresh = refresh || this._updateEditorSelectionValue((String)specification.objectForKey((Object)"task"), "task");
            String string = (String)specification.objectForKey((Object)"entity");
            if (string == null) {
                EOController.Enumeration enumeration = controller.controllerEnumeration(0, EOObjectDisplay._CLASS);
                while (string == null && enumeration.hasMoreElements()) {
                    EOController entityController = enumeration.nextController();
                    if (!entityController.isConnected() || !(entityController instanceof EOComponentController) || !((EOComponentController)entityController).isVisible()) continue;
                    string = ((EOObjectDisplay)entityController).entityName();
                }
            }
            boolean bl = refresh = refresh || this._updateEditorSelectionValue(string, "entity");
            if (refresh) {
                this._refresh();
            }
        }
    }

    public String toString() {
        String key;
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Default Values\n");
        buffer.append("==============\n");
        NSArray keys = this._defaultValuesMapTable.allKeys();
        int count = keys.count();
        for (i = 0; i < count; ++i) {
            key = (String)keys.objectAtIndex(i);
            Object value = this._defaultValuesMapTable.objectForKey((Object)key);
            buffer.append(key + " -> " + (value != _noValuePlaceholder ? value.toString() : "<NO VALUE>") + "\n");
        }
        buffer.append("\nRule Values\n");
        buffer.append("===========\n");
        keys = this._uniqueIdentifierRuleMapTable.allKeys();
        count = keys.count();
        for (i = 0; i < count; ++i) {
            key = (String)keys.objectAtIndex(i);
            EOAssistantRule rule = (EOAssistantRule)this._uniqueIdentifierRuleMapTable.objectForKey((Object)key);
            buffer.append(key + " -> " + rule.value().toString() + "\n");
        }
        buffer.append("\nRules\n");
        buffer.append("=====\n");
        NSArray rules = this.rules();
        count = rules.count();
        for (i = 0; i < count; ++i) {
            buffer.append(rules.objectAtIndex(i).toString() + "\n");
        }
        return buffer.toString();
    }

    public static interface _RuleProvider {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOAssistant$_RuleProvider");

        public void revertRules();

        public void saveRuleDescriptions(NSArray var1);

        public void applyRuleDescriptions(NSArray var1);

        public NSArray ruleDescriptions();

        public Object defaultValue(String var1, NSDictionary var2);

        public NSArray allEntityNames();

        public NSArray allPossibleValuesForKey(String var1);
    }

    public static interface Editor {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOAssistant$Editor");

        public int priority();

        public void refresh();
    }
}

