/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOActionButtonsController;
import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EOSplitController;
import com.webobjects.eogeneration.assistant.EOAssistant;
import com.webobjects.eogeneration.assistant._EOEditorExplanation;
import com.webobjects.eogeneration.assistant._EOEditorStringList;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;

public class EOEntitiesEditor
extends EOComponentController
implements EOAssistant.Editor,
_EOEditorStringList.ChangeListener {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOEntitiesEditor");
    private _EOEditorStringList _mainEntitiesList = null;
    private _EOEditorStringList _enumerationEntitiesList = null;
    private _EOEditorStringList _otherEntitiesList = null;

    public EOEntitiesEditor() {
        this.setLabel("Entities");
        this._mainEntitiesList = new _EOEditorStringList(false, true, "Main Entities", 160, 240, true);
        this._enumerationEntitiesList = new _EOEditorStringList(false, true, "Enumeration Entities", 160, 240, true);
        this._otherEntitiesList = new _EOEditorStringList(true, false, "Other Entities", 160, 240, true);
        this._mainEntitiesList.setReferenceList(this._otherEntitiesList);
        this._enumerationEntitiesList.setReferenceList(this._otherEntitiesList);
        EOComponentController horizontalGroupingController = new EOComponentController();
        horizontalGroupingController.setUsesHorizontalLayout(true);
        EOSplitController verticalSplitController = new EOSplitController();
        EOActionButtonsController mainActionButtonsController = new EOActionButtonsController();
        mainActionButtonsController.setActionWidgetPosition(3);
        mainActionButtonsController.setUsesLargeButtonRepresentation(false);
        EOActionButtonsController enumerationActionButtonsController = new EOActionButtonsController();
        enumerationActionButtonsController.setActionWidgetPosition(3);
        enumerationActionButtonsController.setUsesLargeButtonRepresentation(false);
        mainActionButtonsController.addSubcontroller((EOController)this._mainEntitiesList);
        enumerationActionButtonsController.addSubcontroller((EOController)this._enumerationEntitiesList);
        verticalSplitController.addSubcontroller((EOController)mainActionButtonsController);
        verticalSplitController.addSubcontroller((EOController)enumerationActionButtonsController);
        horizontalGroupingController.addSubcontroller((EOController)this._otherEntitiesList);
        horizontalGroupingController.addSubcontroller((EOController)verticalSplitController);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize the main and enumeration entities:"));
        this.addSubcontroller((EOController)horizontalGroupingController);
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this.refresh();
    }

    public int priority() {
        return 100;
    }

    public void refresh() {
        if (this.isConnected()) {
            EOAssistant assistant = EOAssistant.sharedAssistant();
            NSArray allEntityNames = assistant.allEntityNames();
            NSArray mainEntityNames = (NSArray)assistant.ruleValue("mainEntityNames", null);
            NSArray enumerationEntityNames = (NSArray)assistant.ruleValue("enumerationEntityNames", null);
            NSMutableArray otherEntityNames = new NSMutableArray();
            otherEntityNames.addObjectsFromArray(allEntityNames);
            assistant._filterOutStrings(otherEntityNames, mainEntityNames);
            assistant._filterOutStrings(otherEntityNames, enumerationEntityNames);
            this._otherEntitiesList.establishConnectionToSupercontrollers();
            this._mainEntitiesList.establishConnectionToSupercontrollers();
            this._enumerationEntitiesList.establishConnectionToSupercontrollers();
            this._otherEntitiesList.setStrings((NSArray)otherEntityNames);
            this._mainEntitiesList.setStrings(mainEntityNames);
            this._enumerationEntitiesList.setStrings(enumerationEntityNames);
            this._mainEntitiesList.setCanResetToDefault(assistant.hasRuleValueOtherThanDefault("mainEntityNames", null));
            this._enumerationEntitiesList.setCanResetToDefault(assistant.hasRuleValueOtherThanDefault("enumerationEntityNames", null));
        }
    }

    public void stringListChanged(_EOEditorStringList stringList, NSArray strings) {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        if (stringList == this._mainEntitiesList) {
            assistant.setRuleValue("mainEntityNames", null, new NSArray(strings));
        } else if (stringList == this._enumerationEntitiesList) {
            assistant.setRuleValue("enumerationEntityNames", null, new NSArray(strings));
        }
    }

    public void stringListResetToDefaultRequest(_EOEditorStringList stringList) {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        if (stringList == this._mainEntitiesList) {
            assistant.resetRuleValueToDefault("mainEntityNames", null);
            NSArray entityNames = (NSArray)assistant.ruleValue("mainEntityNames", null);
            this._enumerationEntitiesList.removeStringsIfPresent(entityNames);
        } else if (stringList == this._enumerationEntitiesList) {
            assistant.resetRuleValueToDefault("enumerationEntityNames", null);
            NSArray entityNames = (NSArray)assistant.ruleValue("enumerationEntityNames", null);
            this._mainEntitiesList.removeStringsIfPresent(entityNames);
        }
        this.refresh();
    }
}

