/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOActionButtonsController;
import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eogeneration.assistant.EOAssistant;
import com.webobjects.eogeneration.assistant._EOEditorExplanation;
import com.webobjects.eogeneration.assistant._EOEditorStringAddition;
import com.webobjects.eogeneration.assistant._EOEditorStringList;
import com.webobjects.eogeneration.assistant._EOEditorStringSelector;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;

public class EOPropertiesEditor
extends EOComponentController
implements EOAssistant.Editor,
_EOEditorStringSelector.ChangeListener,
_EOEditorStringList.ChangeListener,
_EOEditorStringAddition.AdditionListener {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOPropertiesEditor");
    private NSMutableDictionary _specification = new NSMutableDictionary(3);
    private NSMutableDictionary _questionIndependentSpecification = new NSMutableDictionary(3);
    private boolean _useQuestionIndependentSpecification = false;
    private _EOEditorStringSelector _entitySelector = null;
    private _EOEditorStringSelector _taskSelector = null;
    private _EOEditorStringSelector _questionSelector = null;
    private _EOEditorStringList _otherKeysList = null;
    private _EOEditorStringList _keysList = null;
    private _EOEditorStringAddition _stringAddition = null;
    private EOActionButtonsController _actionButtonsController = null;

    public EOPropertiesEditor() {
        this.setLabel("Properties");
        this._questionSelector = new _EOEditorStringSelector(true, "Question");
        this._taskSelector = new _EOEditorStringSelector(true, "Task");
        this._entitySelector = new _EOEditorStringSelector(true, "Entity");
        this._otherKeysList = new _EOEditorStringList(true, false, "Other Property Keys", 160, 240, true);
        this._keysList = new _EOEditorStringList(false, true, "Property Keys", 160, 240, true);
        this._stringAddition = new _EOEditorStringAddition("Additional Property Key Path");
        this._keysList.setReferenceList(this._otherKeysList);
        this._actionButtonsController = new EOActionButtonsController();
        this._actionButtonsController.setActionWidgetPosition(3);
        this._actionButtonsController.setUsesLargeButtonRepresentation(false);
        EOComponentController selectorGroupController = new EOComponentController();
        selectorGroupController.setAlignsComponents(true);
        EOComponentController listGroupController = new EOComponentController();
        listGroupController.setUsesHorizontalLayout(true);
        selectorGroupController.addSubcontroller((EOController)this._questionSelector);
        selectorGroupController.addSubcontroller((EOController)this._taskSelector);
        selectorGroupController.addSubcontroller((EOController)this._entitySelector);
        this._actionButtonsController.addSubcontroller((EOController)this._keysList);
        this._actionButtonsController.component();
        listGroupController.addSubcontroller((EOController)this._otherKeysList);
        listGroupController.addSubcontroller((EOController)this._actionButtonsController);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Select a specification:"));
        this.addSubcontroller((EOController)selectorGroupController);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize the property keys for the selected specification:"));
        this.addSubcontroller((EOController)listGroupController);
        this.addSubcontroller((EOController)this._stringAddition);
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this.refresh();
    }

    public int priority() {
        return 200;
    }

    private void _refreshForNewQualifier() {
        this._specification.removeAllObjects();
        this._questionIndependentSpecification.removeAllObjects();
        this._useQuestionIndependentSpecification = false;
        String string = this._entitySelector.selectedString();
        if (string != null) {
            EOClassDescription classDescription = EOClassDescription.classDescriptionForEntityName((String)string);
            this._specification.setObjectForKey((Object)string, (Object)"entity");
            this._questionIndependentSpecification.setObjectForKey((Object)string, (Object)"entity");
            string = this._taskSelector.selectedString();
            this._specification.setObjectForKey((Object)string, (Object)"task");
            this._questionIndependentSpecification.setObjectForKey((Object)string, (Object)"task");
            string = this._questionSelector.selectedString();
            if (string != null && !string.equals("<ALL>")) {
                this._specification.setObjectForKey((Object)string, (Object)"question");
                this._useQuestionIndependentSpecification = true;
            }
            EOAssistant assistant = EOAssistant.sharedAssistant();
            NSArray propertyKeys = (NSArray)assistant.ruleValue("keys", (NSDictionary)this._specification, (NSDictionary)(this._useQuestionIndependentSpecification ? this._questionIndependentSpecification : null));
            this._keysList.setStrings(propertyKeys);
            this._keysList.setCanResetToDefault(assistant.hasRuleValueOtherThanDefault("keys", (NSDictionary)this._specification));
            NSMutableArray otherKeys = new NSMutableArray();
            if (classDescription != null) {
                otherKeys.addObjectsFromArray(classDescription.attributeKeys());
                otherKeys.addObjectsFromArray(classDescription.toOneRelationshipKeys());
                otherKeys.addObjectsFromArray(classDescription.toManyRelationshipKeys());
                assistant._filterOutStrings(otherKeys, propertyKeys);
            }
            this._otherKeysList.setStrings((NSArray)otherKeys);
        } else {
            this._otherKeysList.setStrings(null);
            this._keysList.setStrings(null);
        }
    }

    public void refresh() {
        if (this.isConnected()) {
            this._entitySelector.establishConnectionToSupercontrollers();
            this._taskSelector.establishConnectionToSupercontrollers();
            this._questionSelector.establishConnectionToSupercontrollers();
            this._keysList.establishConnectionToSupercontrollers();
            this._otherKeysList.establishConnectionToSupercontrollers();
            EOAssistant assistant = EOAssistant.sharedAssistant();
            NSMutableArray strings = new NSMutableArray();
            strings.addObject((Object)"<ALL>");
            strings.addObjectsFromArray(assistant.allQuestionNames());
            this._questionSelector.setStrings((NSArray)strings);
            this._questionSelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("question"));
            this._taskSelector.setStrings(assistant.allPropertyKeyTaskNames());
            this._taskSelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("task"));
            this._entitySelector.setStrings(assistant.allEntityNames());
            this._entitySelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("entity"));
            this._refreshForNewQualifier();
        }
    }

    public void stringSelectionChanged(_EOEditorStringSelector stringSelector, String string) {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        if (stringSelector == this._questionSelector) {
            assistant.setEditorSpecificationValueForKey(string, "question");
        } else if (stringSelector == this._taskSelector) {
            assistant.setEditorSpecificationValueForKey(string, "task");
        } else if (stringSelector == this._entitySelector) {
            assistant.setEditorSpecificationValueForKey(string, "entity");
        }
        this._refreshForNewQualifier();
    }

    public void stringListChanged(_EOEditorStringList stringList, NSArray strings) {
        EOAssistant.sharedAssistant().setRuleValue("keys", (NSDictionary)this._specification, new NSArray(strings));
    }

    public void stringListResetToDefaultRequest(_EOEditorStringList stringList) {
        EOAssistant.sharedAssistant().resetRuleValueToDefault("keys", (NSDictionary)this._specification);
        this.refresh();
    }

    public void stringAdded(_EOEditorStringAddition stringAddition, String string) {
        if (string != null && string.length() > 0) {
            this._keysList.addSpecialString(string);
        } else {
            EODialogs.runErrorDialog((String)"Alert", (String)"String can't be empty!");
        }
    }
}

