/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication._EOValueConversion;
import com.webobjects.eogeneration.assistant.EOAssistant;
import com.webobjects.eogeneration.assistant._EOEditorExplanation;
import com.webobjects.eogeneration.assistant._EOEditorSelectionValueCustomizer;
import com.webobjects.eogeneration.assistant._EOEditorStringSelector;
import com.webobjects.eogeneration.assistant._EOEditorStringValueCustomizer;
import com.webobjects.eogeneration.assistant._EOEditorValueCustomizer;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.awt.Dimension;

public class EOWidgetParametersEditor
extends EODocumentController
implements EOAssistant.Editor,
_EOEditorStringSelector.ChangeListener {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOWidgetParametersEditor");
    private _EOEditorStringSelector _taskSelector = null;
    private _EOEditorStringSelector _entitySelector = null;
    private _EOEditorStringSelector _propertyKeySelector = null;
    private _EOEditorSelectionValueCustomizer _typeCustomizer;
    private NSMutableArray _valueCustomizers = new NSMutableArray();

    private void _addValueCustomizers(NSArray customizers, boolean grouped) {
        int count = customizers.count();
        for (int i = 0; i < count; ++i) {
            _EOEditorValueCustomizer valueCustomizer = (_EOEditorValueCustomizer)customizers.objectAtIndex(i);
            this._valueCustomizers.addObject((Object)valueCustomizer);
            if (grouped) {
                valueCustomizer.setMinimumWidgetSize(new Dimension(20, 0));
                valueCustomizer.setDefaultComponentSize(new Dimension(240, 0));
                EOComponentController groupingController = new EOComponentController();
                groupingController.setUsesHorizontalLayout(true);
                groupingController.setAlignsComponents(true);
                groupingController.addSubcontroller((EOController)valueCustomizer);
                if (i < count - 1) {
                    valueCustomizer = (_EOEditorValueCustomizer)customizers.objectAtIndex(++i);
                    this._valueCustomizers.addObject((Object)valueCustomizer);
                }
                groupingController.addSubcontroller((EOController)valueCustomizer);
                this.addSubcontroller((EOController)groupingController);
                continue;
            }
            this.addSubcontroller((EOController)valueCustomizer);
        }
    }

    public EOWidgetParametersEditor() {
        int i;
        this.setLabel("Widgets");
        this.setAlignsComponents(true);
        NSArray booleanValues = _EOValueConversion.stringsForBooleanValues();
        NSArray alignmentValues = _EOValueConversion.stringsForAlignmentValues();
        String defaultDependsOnWidgetString = "<DEFAULT> (depends on widget)";
        String defaultDependsOnTaskString = "<DEFAULT> (depends on task)";
        this._taskSelector = new _EOEditorStringSelector(true, "Task");
        this._entitySelector = new _EOEditorStringSelector(true, "Entity");
        this._propertyKeySelector = new _EOEditorStringSelector(true, "Property Key");
        NSMutableArray generalCustomizers = new NSMutableArray();
        this._typeCustomizer = new _EOEditorSelectionValueCustomizer("widgetController", "Widget Type", null, null);
        this._typeCustomizer.setHighlightsLabel(true);
        generalCustomizers.addObject((Object)this._typeCustomizer);
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("editability", "Editability", defaultDependsOnTaskString, _EOValueConversion.stringsForEditabilityValues()));
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("label", "Label", null, new _EOEditorValueCustomizer.DefaultValue(){

            public String defaultValueForValueKeyAndSpecification(String valueKey, NSDictionary specification) {
                String string = (String)specification.objectForKey((Object)"propertyKey");
                return string != null ? EODisplayUtilities.localizedDisplayLabelForString((String)string) : null;
            }
        }));
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("formatClass", "Format Class", null));
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("formatPattern", "Format Pattern", null));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("formatAllowed", "Format Allowed", "true", booleanValues));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("alignment", "Alignment", "Left", alignmentValues));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("highlight", "Highlight", "false", booleanValues));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("horizontallyResizable", "Horizontally Resizable", defaultDependsOnWidgetString, booleanValues));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("verticallyResizable", "Vertically Resizable", defaultDependsOnWidgetString, booleanValues));
        NSMutableArray groupedGeneralCustomizers = new NSMutableArray();
        groupedGeneralCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumWidth", "Minimum Component Width", null));
        groupedGeneralCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumHeight", "Height", null));
        groupedGeneralCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumWidgetWidth", "Minimum Widget Width", null));
        groupedGeneralCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumWidgetHeight", "Height", null));
        NSMutableArray labelCustomizers = new NSMutableArray();
        labelCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("usesLabelComponent", "Show Label Component", defaultDependsOnWidgetString, booleanValues));
        labelCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("labelAlignment", "Label Component Alignment", "Right", alignmentValues));
        NSMutableArray layoutCustomizers = new NSMutableArray();
        layoutCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("layoutHint", "Layout Hint", defaultDependsOnWidgetString, new NSArray(new Object[]{"Columns", "Row", "FullWidth", "Box", "Switch", "Subwindow", "Inspector", "VerticalSplit", "HorizontalSplit"})));
        _EOEditorValueCustomizer valueCustomizer = new _EOEditorSelectionValueCustomizer("layoutLevel", "Level", "1", new NSArray(new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        valueCustomizer.setMinimumWidgetSize(new Dimension(90, 0));
        valueCustomizer.setCanResizeHorizontally(false);
        layoutCustomizers.addObject((Object)valueCustomizer);
        EOComponentController selectorGroupController = new EOComponentController();
        selectorGroupController.setAlignsComponents(true);
        selectorGroupController.addSubcontroller((EOController)this._taskSelector);
        selectorGroupController.addSubcontroller((EOController)this._entitySelector);
        selectorGroupController.addSubcontroller((EOController)this._propertyKeySelector);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Select an entity and a property key:"));
        this.addSubcontroller((EOController)selectorGroupController);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize widget parameters (some don't apply for all tasks):"));
        this._addValueCustomizers((NSArray)generalCustomizers, false);
        this._addValueCustomizers((NSArray)groupedGeneralCustomizers, true);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize parameters for widgets with label component:"));
        this._addValueCustomizers((NSArray)labelCustomizers, false);
        int count = this._valueCustomizers.count();
        for (i = 0; i < count; ++i) {
            valueCustomizer = (_EOEditorValueCustomizer)this._valueCustomizers.objectAtIndex(i);
            valueCustomizer.setSpecialParameter("widgetController", "controllerType");
        }
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize layout for form windows:"));
        this._addValueCustomizers((NSArray)layoutCustomizers, true);
        count = layoutCustomizers.count();
        for (i = 0; i < count; ++i) {
            valueCustomizer = (_EOEditorValueCustomizer)layoutCustomizers.objectAtIndex(i);
            valueCustomizer.setSpecialParameter("form", "task");
        }
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this.refresh();
    }

    public int priority() {
        return 300;
    }

    private void _refreshForNewQualifier() {
        boolean noTask;
        String taskName = this._taskSelector.selectedString();
        boolean bl = noTask = taskName == null || taskName.equals("<ALL>");
        if (noTask) {
            taskName = null;
        }
        this._typeCustomizer.setEnabled(!noTask);
        String entityName = this._entitySelector.selectedString();
        String propertyKey = this._propertyKeySelector.selectedString();
        int count = this._valueCustomizers.count();
        for (int i = 0; i < count; ++i) {
            ((ValueCustomizer)this._valueCustomizers.objectAtIndex(i)).refreshWithTaskEntityPropertyKeyParameters(taskName, entityName, propertyKey, taskName != null);
        }
    }

    private void _refreshForNewEntity() {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        NSMutableArray propertyKeys = new NSMutableArray();
        String string = this._entitySelector.selectedString();
        if (string != null) {
            NSArray questionNames = assistant.allQuestionNames();
            NSArray taskNames = assistant.allPropertyKeyTaskNames();
            int numberOfQuestionNames = questionNames.count();
            int numberOfTaskNames = taskNames.count();
            NSMutableDictionary specification = new NSMutableDictionary(1 + (numberOfQuestionNames + 1) * numberOfTaskNames);
            specification.setObjectForKey((Object)string, (Object)"entity");
            for (int i = -1; i < numberOfQuestionNames; ++i) {
                if (i >= 0) {
                    specification.setObjectForKey(questionNames.objectAtIndex(i), (Object)"question");
                }
                for (int j = 0; j < numberOfTaskNames; ++j) {
                    specification.setObjectForKey(taskNames.objectAtIndex(j), (Object)"task");
                    assistant._mergeStrings(propertyKeys, (NSArray)assistant.ruleValue("keys", (NSDictionary)specification));
                }
            }
        }
        this._propertyKeySelector.setStrings((NSArray)propertyKeys);
        this._propertyKeySelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("propertyKey"));
        this._refreshForNewQualifier();
    }

    public void refresh() {
        if (this.isConnected()) {
            this._taskSelector.establishConnectionToSupercontrollers();
            this._entitySelector.establishConnectionToSupercontrollers();
            this._propertyKeySelector.establishConnectionToSupercontrollers();
            EOAssistant assistant = EOAssistant.sharedAssistant();
            NSMutableArray strings = new NSMutableArray();
            strings.addObject((Object)"<ALL>");
            strings.addObjectsFromArray(assistant.allPrimitivePropertyKeyTaskNames());
            this._taskSelector.setStrings((NSArray)strings);
            this._taskSelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("task"));
            this._entitySelector.setStrings(assistant.allEntityNames());
            this._entitySelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("entity"));
            this._refreshForNewEntity();
        }
    }

    public void stringSelectionChanged(_EOEditorStringSelector stringSelector, String string) {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        if (stringSelector == this._entitySelector) {
            assistant.setEditorSpecificationValueForKey(string, "entity");
            this._refreshForNewEntity();
        } else if (stringSelector == this._taskSelector) {
            assistant.setEditorSpecificationValueForKey(string, "task");
            this._refreshForNewQualifier();
        } else if (stringSelector == this._propertyKeySelector) {
            assistant.setEditorSpecificationValueForKey(string, "propertyKey");
            this._refreshForNewQualifier();
        }
    }

    public static interface ValueCustomizer {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOWidgetParametersEditor$ValueCustomizer");

        public void refreshWithTaskEntityPropertyKeyParameters(String var1, String var2, String var3, boolean var4);
    }
}

