/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication._EOValueConversion;
import com.webobjects.eogeneration._EOExtendedValueConversion;
import com.webobjects.eogeneration.assistant.EOAssistant;
import com.webobjects.eogeneration.assistant._EOEditorExplanation;
import com.webobjects.eogeneration.assistant._EOEditorSelectionValueCustomizer;
import com.webobjects.eogeneration.assistant._EOEditorStringSelector;
import com.webobjects.eogeneration.assistant._EOEditorStringValueCustomizer;
import com.webobjects.eogeneration.assistant._EOEditorValueCustomizer;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;

public class EOWindowParametersEditor
extends EODocumentController
implements EOAssistant.Editor,
_EOEditorStringSelector.ChangeListener {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOWindowParametersEditor");
    private _EOEditorStringSelector _entitySelector = null;
    private _EOEditorStringSelector _taskSelector = null;
    private _EOEditorStringSelector _questionSelector = null;
    private _EOEditorSelectionValueCustomizer _typeCustomizer;
    private NSMutableArray _valueCustomizers = new NSMutableArray();
    private boolean _entitySelectionAllowed = false;

    public EOWindowParametersEditor() {
        _EOEditorValueCustomizer valueCustomizer;
        int i;
        this.setLabel("Windows");
        this.setAlignsComponents(true);
        NSArray booleanValues = _EOValueConversion.stringsForBooleanValues();
        this._questionSelector = new _EOEditorStringSelector(true, "Question");
        this._taskSelector = new _EOEditorStringSelector(true, "Task");
        this._entitySelector = new _EOEditorStringSelector(true, "Entity");
        NSMutableArray generalCustomizers = new NSMutableArray();
        this._typeCustomizer = new _EOEditorSelectionValueCustomizer("", "Window Type", null, NSArray.EmptyArray);
        this._typeCustomizer.setHighlightsLabel(true);
        generalCustomizers.addObject((Object)this._typeCustomizer);
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("label", "Label", null, new _EOEditorValueCustomizer.DefaultValue(){

            public String defaultValueForValueKeyAndSpecification(String valueKey, NSDictionary specification) {
                String string = (String)specification.objectForKey((Object)"entity");
                return string != null ? EODisplayUtilities.localizedDisplayLabelForString((String)string) : null;
            }
        }));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("windowPosition", "Position", "Center", _EOValueConversion.stringsForPositionValues()));
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumWidth", "Minimum Width", null));
        generalCustomizers.addObject((Object)new _EOEditorStringValueCustomizer("minimumHeight", "Minimum Height", null));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("usesUserDefaultsWindowSize", "User Defaults For Window Size", "true", booleanValues));
        generalCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("usesUserDefaultsWindowLocation", "User Defaults For Window Location", "false", booleanValues));
        NSMutableArray factoryCustomizers = new NSMutableArray();
        factoryCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("reuseMode", "Factory Reuse Mode", "NeverReuse", _EOExtendedValueConversion.stringsForReuseModeValues()));
        factoryCustomizers.addObject((Object)new _EOEditorSelectionValueCustomizer("disposeIfDeactivated", "Dispose If Deactivated", "false", booleanValues));
        EOComponentController selectorGroupController = new EOComponentController();
        selectorGroupController.setAlignsComponents(true);
        selectorGroupController.addSubcontroller((EOController)this._questionSelector);
        selectorGroupController.addSubcontroller((EOController)this._taskSelector);
        selectorGroupController.addSubcontroller((EOController)this._entitySelector);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Select a specification:"));
        this.addSubcontroller((EOController)selectorGroupController);
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize window parameters:"));
        int count = generalCustomizers.count();
        for (i = 0; i < count; ++i) {
            valueCustomizer = (_EOEditorValueCustomizer)generalCustomizers.objectAtIndex(i);
            this._valueCustomizers.addObject((Object)valueCustomizer);
            this.addSubcontroller((EOController)valueCustomizer);
        }
        this.addSubcontroller((EOController)new _EOEditorExplanation("Customize runtime behavior:"));
        count = factoryCustomizers.count();
        for (i = 0; i < count; ++i) {
            valueCustomizer = (_EOEditorValueCustomizer)factoryCustomizers.objectAtIndex(i);
            this._valueCustomizers.addObject((Object)valueCustomizer);
            this.addSubcontroller((EOController)valueCustomizer);
        }
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this.refresh();
    }

    public int priority() {
        return 400;
    }

    private void _refreshForNewQualifier() {
        String question = this._questionSelector.selectedString();
        String taskName = this._taskSelector.selectedString();
        String entityName = this._entitySelector.selectedString();
        if (entityName != null && entityName.equals("<ALL>")) {
            entityName = null;
        }
        String controllerType = question + "Controller";
        int count = this._valueCustomizers.count();
        for (int i = 0; i < count; ++i) {
            _EOEditorValueCustomizer valueCustomizer = (_EOEditorValueCustomizer)this._valueCustomizers.objectAtIndex(i);
            valueCustomizer.setSpecialParameter(controllerType, "controllerType");
            valueCustomizer.refreshWithEntityTaskQuestionParameters(entityName, taskName, question, entityName != null);
        }
    }

    private void _refreshForNewTask() {
        this._entitySelectionAllowed = false;
        NSMutableArray strings = new NSMutableArray();
        String question = this._questionSelector.selectedString();
        String taskName = this._taskSelector.selectedString();
        if (question != null && taskName != null) {
            strings = EOAssistant.sharedAssistant()._allQuestionTaskNames(question, true);
            this._entitySelectionAllowed = strings.indexOfObject((Object)taskName) >= 0;
        }
        this._entitySelector.setSelectionEnabled(this._entitySelectionAllowed);
        this._refreshForNewQualifier();
    }

    private void _refreshForNewQuestion() {
        String question = this._questionSelector.selectedString();
        if (question != null) {
            EOAssistant assistant = EOAssistant.sharedAssistant();
            NSMutableArray strings = new NSMutableArray();
            strings.addObjectsFromArray(assistant._allQuestionTaskNames(question, true));
            strings.addObjectsFromArray(assistant._allQuestionTaskNames(question, false));
            this._taskSelector.setStrings((NSArray)strings);
            this._taskSelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("task"));
            this._typeCustomizer.resetValueKey(question + "Controller", null);
        }
        this._refreshForNewTask();
    }

    public void refresh() {
        if (this.isConnected()) {
            this._entitySelector.establishConnectionToSupercontrollers();
            this._taskSelector.establishConnectionToSupercontrollers();
            this._questionSelector.establishConnectionToSupercontrollers();
            EOAssistant assistant = EOAssistant.sharedAssistant();
            this._questionSelector.setStrings(assistant.allQuestionNames());
            this._questionSelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("question"));
            NSMutableArray strings = new NSMutableArray();
            strings.addObject((Object)"<ALL>");
            strings.addObjectsFromArray(assistant.allEntityNames());
            this._entitySelector.setStrings((NSArray)strings);
            this._entitySelector.tryToUpdateSelectionToString(assistant.editorSpecificationValueForKey("entity"));
            this._refreshForNewQuestion();
        }
    }

    public void stringSelectionChanged(_EOEditorStringSelector stringSelector, String string) {
        EOAssistant assistant = EOAssistant.sharedAssistant();
        if (stringSelector == this._questionSelector) {
            assistant.setEditorSpecificationValueForKey(string, "question");
            this._refreshForNewQuestion();
        } else if (stringSelector == this._taskSelector) {
            assistant.setEditorSpecificationValueForKey(string, "task");
            this._refreshForNewTask();
        } else if (stringSelector == this._entitySelector) {
            assistant.setEditorSpecificationValueForKey(string, "entity");
            this._refreshForNewQualifier();
        }
    }

    public static interface ValueCustomizer {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOWindowParametersEditor$ValueCustomizer");

        public void refreshWithEntityTaskQuestionParameters(String var1, String var2, String var3, boolean var4);
    }
}

