/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication.EOSplitController;
import com.webobjects.eoapplication._EODebugUtilities;
import com.webobjects.eocontrol.EOCustomObject;
import com.webobjects.eogeneration.EOActionController;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.eogeneration.EOTableColumnController;
import com.webobjects.eogeneration.EOTableController;
import com.webobjects.eogeneration.EOTextAreaController;
import com.webobjects.eogeneration.assistant.EOAssistant;
import com.webobjects.eointerface.EODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;

public class EOXMLEditor
extends EODocumentController
implements EOAssistant.Editor {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant.EOXMLEditor");
    private String _suggestedFileName = null;

    public EOXMLEditor() {
        this.setEditability(0);
        this.setLabel("XML");
        EOSplitController splitController = new EOSplitController();
        EOTableController tableController = new EOTableController();
        tableController.setAllowsMultipleSelection(false);
        tableController.setSortsByColumnOrder(false);
        EOTableColumnController tableColumnController = new EOTableColumnController();
        tableColumnController.setValueKey("description");
        tableColumnController.setLabel("Specification");
        tableColumnController.setEditability(0);
        EOTextAreaController textAreaController = new EOTextAreaController();
        textAreaController.setValueKey("xml");
        textAreaController.setUsesLabelComponent(false);
        textAreaController.setCanResizeVertically(true);
        textAreaController.setEditability(0);
        EOActionController saveToFileActionController = new EOActionController();
        saveToFileActionController.setActionKey("saveToFile");
        saveToFileActionController.setEditability(1);
        tableController.addSubcontroller((EOController)tableColumnController);
        splitController.addSubcontroller((EOController)tableController);
        splitController.addSubcontroller((EOController)textAreaController);
        this.addSubcontroller((EOController)splitController);
        this.addSubcontroller((EOController)saveToFileActionController);
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this.refresh();
    }

    public boolean fetchesOnConnect() {
        return false;
    }

    protected EODisplayGroup _defaultDisplayGroup() {
        EODisplayGroup displayGroup = new EODisplayGroup();
        displayGroup.setFetchesOnLoad(false);
        displayGroup.setSelectsFirstObjectAfterFetch(true);
        displayGroup.setUsesOptimisticRefresh(false);
        this._addToDisposableRegistry((NSDisposable)displayGroup);
        return displayGroup;
    }

    public int priority() {
        return 1000;
    }

    public void refresh() {
        if (this.isConnected()) {
            NSMutableArray displayObjects = new NSMutableArray();
            EOControllerFactory factory = EOControllerFactory.sharedControllerFactory();
            NSArray specifications = factory._availableSpecifications();
            int count = specifications.count();
            for (int i = 0; i < count; ++i) {
                displayObjects.addObject((Object)new _DisplayObject((NSDictionary)specifications.objectAtIndex(i), true));
            }
            try {
                displayObjects.sortUsingComparator(new NSComparator(){

                    public int compare(Object object1, Object object2) throws NSComparator.ComparisonException {
                        return NSComparator._compareObjects((Comparable)((Object)((_DisplayObject)((Object)object1)).description()), (Comparable)((Object)((_DisplayObject)((Object)object2)).description()));
                    }
                });
            }
            catch (NSComparator.ComparisonException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
            displayObjects.addObject((Object)new _DisplayObject(factory._specificationWithParameters("actions", null, null), false));
            displayObjects.addObject((Object)new _DisplayObject(factory._specificationWithParameters("availableSpecifications", null, null), false));
            displayObjects.addObject((Object)new _DisplayObject(factory._specificationWithParameters("defaultSpecifications", null, null), false));
            displayObjects.addObject((Object)new _DisplayObject(factory._specificationWithParameters("userInterfaceParameters", null, null), false));
            this.displayGroup().setObjectArray((NSArray)displayObjects);
        }
    }

    public void saveXMLToFile(String xml) {
        JFileChooser fileChooser = new JFileChooser(this._suggestedFileName != null ? new File(this._suggestedFileName) : null);
        fileChooser.setDialogTitle("Save XML");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showSaveDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            this._suggestedFileName = file.getPath();
            if (file.exists()) {
                EODialogs.runErrorDialog((String)"Alert", (String)"File already exists! Please choose another file name...");
            } else {
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(xml, 0, xml.length());
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException exception) {
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8192L)) {
                        NSLog.debug.appendln((Object)("Could not save file " + file + ": " + exception.getMessage()));
                        NSLog.debug.appendln((Throwable)exception);
                    }
                    EODialogs.runErrorDialog((String)"I/O Error", (String)("Writing file " + file.getName() + " failed!"));
                }
            }
        }
    }

    public class _DisplayObject
    extends EOCustomObject {
        private NSDictionary _specification;
        private String _description;
        private String _xml;
        private boolean _useXMLFromControllerFactory;

        public _DisplayObject(NSDictionary specification, boolean useXMLFromControllerFactory) {
            this._specification = specification;
            this._xml = null;
            this._description = null;
            this._useXMLFromControllerFactory = useXMLFromControllerFactory;
        }

        public String description() {
            this.willRead();
            if (this._description == null) {
                this._description = EOControllerFactory.sharedControllerFactory()._uniqueDescriptionForSpecification(this._specification);
                if (this._description == null) {
                    this._description = "<ERROR>";
                }
            }
            return this._description;
        }

        public String xml() {
            this.willRead();
            if (this._xml == null) {
                Object object = null;
                if (this._useXMLFromControllerFactory) {
                    EOControllerFactory._SpecificationData specificationData = EOControllerFactory.sharedControllerFactory()._specificationDataIfAvailable(this._specification, true, false);
                    if (specificationData != null && specificationData != EOControllerFactory._SpecificationData._unavailablePlaceholder) {
                        object = specificationData.rootObjectArchive();
                    }
                } else {
                    object = EOControllerFactory.sharedControllerFactory().evaluateRules(this._specification);
                }
                this._xml = object != null ? _EODebugUtilities.XMLDescription((Object)object) : "XML not available...";
            }
            return this._xml;
        }

        public void saveToFile() {
            EOXMLEditor.this.saveXMLToFile(this.xml());
        }
    }
}

