/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EOEntityController;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eocontrol.EOCustomObject;
import com.webobjects.eogeneration.EOTableColumnController;
import com.webobjects.eogeneration.EOTableController;
import com.webobjects.eointerface.EODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import javax.swing.Icon;

public class _EOEditorStringList
extends EOEntityController {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant._EOEditorStringList");
    private static NSMutableArray _defaultActions;
    private NSMutableArray _strings = new NSMutableArray();
    private boolean _keepStringsSorted;
    private boolean _provideDefaultActions;
    private boolean _canResetToDefault;
    private _EOEditorStringList _referenceList;

    private static NSArray _defaultActions() {
        if (_defaultActions == null) {
            _defaultActions = new NSMutableArray();
            Icon icon = EOUserInterfaceParameters.localizedIcon((String)"ArrowRight");
            _defaultActions.addObject((Object)EOAction.actionForControllerHierarchy((String)"add", null, null, (Icon)icon, (Icon)icon, null, (int)100, (int)100, (boolean)false));
            icon = EOUserInterfaceParameters.localizedIcon((String)"ArrowLeft");
            _defaultActions.addObject((Object)EOAction.actionForControllerHierarchy((String)"remove", null, null, (Icon)icon, (Icon)icon, null, (int)100, (int)110, (boolean)false));
            icon = EOUserInterfaceParameters.localizedIcon((String)"ArrowUp");
            _defaultActions.addObject((Object)EOAction.actionForControllerHierarchy((String)"up", null, null, (Icon)icon, (Icon)icon, null, (int)100, (int)120, (boolean)false));
            icon = EOUserInterfaceParameters.localizedIcon((String)"ArrowDown");
            _defaultActions.addObject((Object)EOAction.actionForControllerHierarchy((String)"down", null, null, (Icon)icon, (Icon)icon, null, (int)100, (int)130, (boolean)false));
            icon = EOUserInterfaceParameters.localizedIcon((String)"Default");
            _defaultActions.addObject((Object)EOAction.actionForControllerHierarchy((String)"resetToDefault", null, null, (Icon)icon, (Icon)icon, null, (int)100, (int)300, (boolean)false));
        }
        return _defaultActions;
    }

    public _EOEditorStringList(boolean keepStringsSorted, boolean provideDefaultActions, String label, int tableWidth, int tableHeight, boolean canResizeVertically) {
        this._keepStringsSorted = keepStringsSorted;
        this._provideDefaultActions = provideDefaultActions;
        this._canResetToDefault = false;
        this.setLabel(label);
        this.setCanResizeVertically(canResizeVertically);
        EOTableController tableController = new EOTableController();
        tableController._setDefaultComponentSize(tableWidth, tableHeight);
        tableController.setSortsByColumnOrder(false);
        EOTableColumnController tableColumnController = new EOTableColumnController();
        tableColumnController.setValueKey("string");
        tableColumnController.setLabel(label);
        tableColumnController.setEditability(0);
        tableController.addSubcontroller((EOController)tableColumnController);
        this.addSubcontroller((EOController)tableController);
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this._update(null);
    }

    public boolean fetchesOnConnect() {
        return false;
    }

    protected EODisplayGroup _defaultDisplayGroup() {
        EODisplayGroup displayGroup = new EODisplayGroup();
        displayGroup.setFetchesOnLoad(false);
        displayGroup.setSelectsFirstObjectAfterFetch(true);
        displayGroup.setUsesOptimisticRefresh(false);
        this._addToDisposableRegistry((NSDisposable)displayGroup);
        return displayGroup;
    }

    public void setReferenceList(_EOEditorStringList referenceList) {
        this._referenceList = referenceList;
    }

    public _EOEditorStringList referenceList() {
        return this._referenceList;
    }

    public void _update(NSArray selection) {
        if (this.isConnected()) {
            EODisplayGroup displayGroup = this.displayGroup();
            NSArray selectedObjects = selection != null ? selection : displayGroup.selectedObjects();
            int numberOfSelectedObjects = selectedObjects.count();
            NSMutableArray displayObjects = new NSMutableArray();
            NSMutableArray updatedSelectedObjects = new NSMutableArray();
            NSArray strings = this.strings();
            int numberOfStrings = strings.count();
            for (int i = 0; i < numberOfStrings; ++i) {
                String string = (String)strings.objectAtIndex(i);
                _Object displayObject = new _Object(string);
                displayObjects.addObject((Object)displayObject);
                for (int j = 0; j < numberOfSelectedObjects; ++j) {
                    String compareString;
                    Object compareObject = selectedObjects.objectAtIndex(j);
                    String string2 = compareString = compareObject instanceof _Object ? ((_Object)((Object)compareObject)).string() : (String)compareObject;
                    if (!string.equals(compareString)) continue;
                    updatedSelectedObjects.addObject((Object)displayObject);
                }
            }
            if (updatedSelectedObjects.count() == 0 && displayObjects.count() > 0) {
                updatedSelectedObjects.addObject(displayObjects.objectAtIndex(0));
            }
            displayGroup.setObjectArray((NSArray)displayObjects);
            displayGroup.setSelectedObjects((NSArray)updatedSelectedObjects);
        }
    }

    public void setStringsWithSelection(NSArray strings, NSArray selection) {
        this._strings.removeAllObjects();
        if (strings != null) {
            this._strings.addObjectsFromArray(strings);
        }
        if (this._keepStringsSorted) {
            try {
                this._strings.sortUsingComparator(NSComparator.AscendingStringComparator);
            }
            catch (NSComparator.ComparisonException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        this._update(selection);
    }

    public void setStrings(NSArray strings) {
        this.setStringsWithSelection(strings, null);
    }

    public NSArray strings() {
        return this._strings;
    }

    public void removeStringsIfPresent(NSArray strings) {
        if (strings != null) {
            NSMutableArray reducedStrings = new NSMutableArray(this.strings());
            int count = reducedStrings.count();
            reducedStrings.removeObjectsInArray(strings);
            if (count != reducedStrings.count()) {
                this.setStringsWithSelection((NSArray)reducedStrings, this.selectedStrings());
                this._fireChangeNotification();
            }
        }
    }

    public NSArray selectedStrings() {
        NSMutableArray strings = new NSMutableArray();
        NSArray selectedObjects = this.displayGroup().selectedObjects();
        int count = selectedObjects.count();
        for (int i = 0; i < count; ++i) {
            strings.addObject((Object)((_Object)((Object)selectedObjects.objectAtIndex(i))).string());
        }
        return strings;
    }

    public int numberOfSelectedStrings() {
        return this.displayGroup().selectedObjects().count();
    }

    public int indexOfSingleSelectedString() {
        NSArray selectionIndexes = this.displayGroup().selectionIndexes();
        return selectionIndexes.count() == 1 ? ((Number)selectionIndexes.objectAtIndex(0)).intValue() : -1;
    }

    public void setCanResetToDefault(boolean flag) {
        this._canResetToDefault = flag;
    }

    public boolean canResetToDefault() {
        return this._canResetToDefault;
    }

    protected NSArray defaultActions() {
        return this._provideDefaultActions ? _EOEditorStringList._defaultActions() : null;
    }

    public boolean canPerformActionNamed(String actionName) {
        if (this._provideDefaultActions) {
            if (actionName.equals("add")) {
                _EOEditorStringList referenceList = this.referenceList();
                return referenceList != null && referenceList.numberOfSelectedStrings() > 0;
            }
            if (actionName.equals("remove")) {
                return this.numberOfSelectedStrings() > 0;
            }
            if (actionName.equals("up")) {
                return this.numberOfSelectedStrings() == 1 && this.indexOfSingleSelectedString() > 0;
            }
            if (actionName.equals("down")) {
                return this.numberOfSelectedStrings() == 1 && this.indexOfSingleSelectedString() < this.strings().count() - 1;
            }
            if (actionName.equals("resetToDefault")) {
                return this._canResetToDefault;
            }
        }
        return false;
    }

    public void _addString(String string) {
        if (string != null) {
            NSMutableArray strings = new NSMutableArray();
            strings.addObjectsFromArray(this.strings());
            strings.addObject((Object)string);
            this.setStringsWithSelection((NSArray)strings, new NSArray((Object)string));
            _EOEditorStringList referenceList = this.referenceList();
            if (referenceList != null) {
                referenceList._removeString(string);
            }
        }
    }

    public void _removeString(String string) {
        if (string != null) {
            NSMutableArray reducedStrings = new NSMutableArray();
            NSArray strings = this.strings();
            int count = strings.count();
            for (int i = 0; i < count; ++i) {
                String testString = (String)strings.objectAtIndex(i);
                if (testString.equals(string)) continue;
                reducedStrings.addObject((Object)testString);
            }
            this.setStringsWithSelection((NSArray)reducedStrings, this.selectedStrings());
            _EOEditorStringList referenceList = this.referenceList();
            if (referenceList != null) {
                referenceList._addString(string);
            }
        }
    }

    private void _removeSelectedStrings() {
        int i;
        int index = -1;
        NSArray selectionIndexes = this.displayGroup().selectionIndexes();
        int count = selectionIndexes.count();
        for (i = 0; i < count; ++i) {
            int testIndex = ((Number)selectionIndexes.objectAtIndex(i)).intValue();
            if (index >= 0 && testIndex >= index) continue;
            index = testIndex;
        }
        NSArray selectedStrings = this.selectedStrings();
        if (selectedStrings.count() > 0) {
            NSMutableArray reducedStrings = new NSMutableArray();
            NSArray strings = this.strings();
            count = strings.count();
            for (i = 0; i < count; ++i) {
                String string = (String)strings.objectAtIndex(i);
                if (selectedStrings.indexOfObject((Object)string) >= 0) continue;
                reducedStrings.addObject((Object)string);
            }
            NSMutableArray reducedSelectedStrings = new NSMutableArray();
            count = reducedStrings.count();
            if (index > 0 && index < count) {
                reducedSelectedStrings.addObject(reducedStrings.objectAtIndex(index));
            } else if (count > 0) {
                reducedSelectedStrings.addObject(reducedStrings.objectAtIndex(0));
            }
            this.setStringsWithSelection((NSArray)reducedStrings, (NSArray)reducedSelectedStrings);
        }
    }

    private void _addFromReferenceList(_EOEditorStringList referenceList) {
        NSArray selectedStrings = referenceList.selectedStrings();
        if (selectedStrings != null) {
            NSMutableArray strings = new NSMutableArray();
            strings.addObjectsFromArray(this.strings());
            int count = selectedStrings.count();
            for (int i = 0; i < count; ++i) {
                String string = (String)selectedStrings.objectAtIndex(i);
                if (strings.indexOfObject((Object)string) >= 0) continue;
                strings.addObject((Object)string);
            }
            this.setStringsWithSelection((NSArray)strings, selectedStrings);
        }
    }

    public void resetToDefault() {
        if (this.canResetToDefault()) {
            this.invokeMethod(2, ChangeListener._CLASS, "stringListResetToDefaultRequest", new Class[]{_CLASS}, new Object[]{this});
        }
    }

    public void _fireChangeNotification() {
        this.invokeMethod(2, ChangeListener._CLASS, "stringListChanged", new Class[]{_CLASS, NSArray._CLASS}, new Object[]{this, this.strings()});
        this.setCanResetToDefault(true);
    }

    public void addSpecialString(String string) {
        this._addString(string);
        this._fireChangeNotification();
    }

    public void add() {
        _EOEditorStringList referenceList = this.referenceList();
        if (referenceList != null) {
            this._addFromReferenceList(referenceList);
            referenceList._removeSelectedStrings();
            this._fireChangeNotification();
        }
    }

    public void remove() {
        _EOEditorStringList referenceList = this.referenceList();
        if (referenceList != null) {
            referenceList._addFromReferenceList(this);
        }
        this._removeSelectedStrings();
        this._fireChangeNotification();
    }

    public void up() {
        int index = this.indexOfSingleSelectedString();
        NSArray strings = this.strings();
        if (index > 0 && index < strings.count()) {
            NSMutableArray reorderedStrings = new NSMutableArray();
            reorderedStrings.addObjectsFromArray(strings);
            Object string = reorderedStrings.objectAtIndex(index);
            reorderedStrings.removeObjectAtIndex(index);
            reorderedStrings.insertObjectAtIndex(string, index - 1);
            this.setStrings((NSArray)reorderedStrings);
            this._fireChangeNotification();
        }
    }

    public void down() {
        int index = this.indexOfSingleSelectedString();
        NSArray strings = this.strings();
        if (index >= 0 && index < strings.count() - 1) {
            NSMutableArray reorderedStrings = new NSMutableArray();
            reorderedStrings.addObjectsFromArray(strings);
            Object string = reorderedStrings.objectAtIndex(index);
            reorderedStrings.removeObjectAtIndex(index);
            reorderedStrings.insertObjectAtIndex(string, index + 1);
            this.setStrings((NSArray)reorderedStrings);
            this._fireChangeNotification();
        }
    }

    public static class _Object
    extends EOCustomObject {
        private String _string;

        public _Object(String string) {
            this._string = string;
        }

        public String string() {
            this.willRead();
            return this._string;
        }
    }

    public static interface ChangeListener {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant._EOEditorStringList$ChangeListener");

        public void stringListChanged(_EOEditorStringList var1, NSArray var2);

        public void stringListResetToDefaultRequest(_EOEditorStringList var1);
    }
}

