/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration.assistant;

import com.webobjects.eoapplication._EOWidgetUtilities;
import com.webobjects.eogeneration.EOWidgetController;
import com.webobjects.eointerface.swing.EOSwingUtilities;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class _EOEditorStringSelector
extends EOWidgetController {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant._EOEditorStringSelector");
    private NSMutableArray _strings = new NSMutableArray();
    private boolean _keepStringsSorted;
    private String _selectedString;
    private boolean _selectionEnabled;
    private boolean _ignoreSelectionChange;

    public _EOEditorStringSelector(boolean keepStringsSorted, String label) {
        this._keepStringsSorted = keepStringsSorted;
        this._selectedString = null;
        this._selectionEnabled = true;
        this._ignoreSelectionChange = false;
        this.setLabel(label);
        this.setUsesLabelComponent(true);
        this.setCanResizeVertically(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        JComboBox comboBox = (JComboBox)this.widget();
        super.dispose();
        if (comboBox != null) {
            this._ignoreSelectionChange = true;
            try {
                comboBox.setModel(new DefaultComboBoxModel());
            }
            finally {
                this._ignoreSelectionChange = false;
            }
        }
    }

    protected void connectionWasEstablished() {
        super.connectionWasEstablished();
        this._update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent newWidget() {
        JComboBox comboBox;
        this._ignoreSelectionChange = true;
        try {
            comboBox = _EOWidgetUtilities.newActionComboBox((boolean)true, (ComboBoxModel)new _Model());
        }
        finally {
            this._ignoreSelectionChange = false;
        }
        return comboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionEnabled(boolean flag) {
        if (this._selectionEnabled != flag) {
            this._selectionEnabled = flag;
            JComboBox comboBox = (JComboBox)this.widget();
            if (comboBox != null) {
                this._ignoreSelectionChange = true;
                try {
                    if (this._selectionEnabled) {
                        comboBox.setModel(new _Model());
                    } else {
                        comboBox.setModel(new DefaultComboBoxModel());
                    }
                }
                finally {
                    this._ignoreSelectionChange = false;
                }
                comboBox.setEnabled(this._selectionEnabled);
                comboBox.repaint();
            }
        }
    }

    public boolean isSelectionEnabled() {
        return this._selectionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _update(String selection) {
        if (this.isConnected()) {
            String string = selection != null ? selection : this._selectedString;
            this._selectedString = null;
            NSArray strings = this.strings();
            if (string != null && strings.indexOfObject((Object)string) >= 0) {
                this._selectedString = string;
            }
            if (this._selectedString == null && strings.count() > 0) {
                this._selectedString = (String)strings.objectAtIndex(0);
            }
            JComboBox comboBox = (JComboBox)this.widget();
            this._ignoreSelectionChange = true;
            try {
                comboBox.setModel(new _Model());
                comboBox.repaint();
            }
            finally {
                this._ignoreSelectionChange = false;
            }
        }
    }

    public void setStringsWithSelection(NSArray strings, String selection) {
        this._strings.removeAllObjects();
        if (strings != null) {
            this._strings.addObjectsFromArray(strings);
        }
        if (this._keepStringsSorted) {
            try {
                this._strings.sortUsingComparator(NSComparator.AscendingStringComparator);
            }
            catch (NSComparator.ComparisonException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
        this._update(selection);
    }

    public void setStrings(NSArray strings) {
        this.setStringsWithSelection(strings, null);
    }

    public NSArray strings() {
        return this._strings;
    }

    protected void _setSelectedString(String string) {
        if (!this._ignoreSelectionChange) {
            String selectedString = this.selectedString();
            if (selectedString == string || selectedString != null && string != null && selectedString.equals(string)) {
                return;
            }
            this._update(string);
            this.invokeMethod(2, ChangeListener._CLASS, "stringSelectionChanged", new Class[]{_CLASS, _NSUtilities._StringClass}, new Object[]{this, this._selectedString});
        }
    }

    public String selectedString() {
        return this._selectionEnabled ? this._selectedString : null;
    }

    public void tryToUpdateSelectionToString(String string) {
        if (string != null) {
            NSArray strings = this.strings();
            String selectedString = this.selectedString();
            if (!(selectedString == string || selectedString != null && selectedString.equals(string) || selectedString != null && selectedString.startsWith("<ALL>"))) {
                if (strings.indexOfObject((Object)string) >= 0) {
                    this._update(string);
                } else {
                    int count = strings.count();
                    for (int i = 0; i < count; ++i) {
                        String compareString = (String)strings.objectAtIndex(i);
                        if (!compareString.startsWith(string) && !string.startsWith(compareString)) continue;
                        string = compareString;
                        this._update(string);
                        break;
                    }
                }
            }
        }
    }

    private class _Model
    extends AbstractListModel
    implements ComboBoxModel {
        public int getSize() {
            return _EOEditorStringSelector.this.strings().count();
        }

        public Object getElementAt(int index) {
            NSArray strings = _EOEditorStringSelector.this.strings();
            return index >= 0 && index < strings.count() ? strings.objectAtIndex(index) : "";
        }

        public Object getSelectedItem() {
            String selectedString = _EOEditorStringSelector.this.selectedString();
            return selectedString != null ? selectedString : "";
        }

        public void setSelectedItem(Object item) {
            _EOEditorStringSelector.this._setSelectedString((String)item);
            EOSwingUtilities.eventEnded();
        }
    }

    public static interface ChangeListener {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.assistant._EOEditorStringSelector$ChangeListener");

        public void stringSelectionChanged(_EOEditorStringSelector var1, String var2);
    }
}

